#include "IOobjects.h"

Watchdog wdt;                      // Watchdog timer (TIMEOUT (sec))
DigitalIn sw[]={                   // Shutdown switch sense lines
    DigitalIn(P1_0, PullDown),     // Sense0 - fuse power
    DigitalIn(P1_1, PullDown),     // Sense1 - AMS latch
    DigitalIn(P1_4, PullDown),     // Sense2 - IMD latch
    DigitalIn(P1_8, PullDown),     // Sense3 - PCM relay
    DigitalIn(P1_9, PullDown),     // Sense4 - Brake plausibility relay
    DigitalIn(P1_10, PullDown),    // Sense5 - Left e-stop
    DigitalIn(P1_14, PullDown),    // Sense6 - Brake over-travel
    DigitalIn(P1_15, PullDown),    // Sense7 - Inertia switch
    DigitalIn(P1_16, PullDown),    // Sense8 - Cockpit e-stop
    DigitalIn(P1_17, PullDown),    // Sense9 - Right e-stop
    DigitalIn(P1_27, PullDown),    // Sense10 - HVD/Charger
    DigitalIn(P1_28, PullDown),    // Sense11 - TSMS/tractive enable
};
PollSwitch switches(sw, sizeof(sw)/sizeof(sw[0]));   // Shutdown switch sense pins (SWITCH PIN ARRAY, NUM PINS)
CANBuffer can(CAN2, MEDIUM, P4_28, 1, 1);            // Buffered CAN interface (PORT, SPEED, SILENT PIN)
CoulombCounter glvBat(p19, FAST_LOOP*1000, 1);       // Coulomb counter battery monitor for GLV Battery (CURRENT SENSE PIN, INTEGRATION TIME)
IMD imd(P1_26);                                      // IMD PWM sense channel to read status and resistance (IMD PWM PIN)
LatchMonitor AMSlatch(P0_18, P0_22);                 // Supervisor for AMS hardware latch/reset circuit (OK PIN, FAULT PIN, STARTUP DELAY (ms))
LatchMonitor IMDlatch(P0_17, P0_21);                 // Supervisor for IMD hardware latch/reset circuit (OK PIN, FAULT PIN, STARTUP DELAY (ms))
DC_DC dcdc(p18, p20, p26, p25, p24, p23, 0.01, 5, 1);// DC-DC converter & high-current load control (CONTROL PIN, CURRENT SENSE PIN, FAN1 PIN, FAN2 PIN, PUMP1 PIN, PUMP2 PIN, PWM PERIOD (sec), FULL-SCALE SLEW (sec))
Temperature internalTmp(&NXFT15XH103_TABLE, p15);    // Temperature conversion look-up table for internal temperature on the GLV bat charger FET (TABLE PTR, PIN)
//XbeeManager xbeeRelay(p9, p10, p13, p14, XBEE_BAUD, 1, 1);
MODSERIAL pc(USBTX, USBRX, 1, RX_SIZE);              // Software buffered serial
XbeeRelay xbee;
DigitalOut extras[] = {(p16), (p17)};                // Unused analog pins driven low
