#ifndef TEMPORARY_DATA_H
#define TEMPORARY_DATA_H

#include "FreezeFrame.h"
#include <string.h>

// For temporary data that changes frequently in operation for inter-task communication.
// NOTE there are no mutexes/protection mechanisms.  Ensure single producer, single consumer.
class TemporaryData
{
public:
    TemporaryData() {
        memset(this, 0, sizeof(TemporaryData));
        parseGoodChar = ' ';    // Start with a blank after the "Command Input:" line
        viewProfileNum = -2;    // -2 = display live RAM profile
    }
    char inputStr[RX_SIZE+1];   // Stores the user-typed command input string for serial interface
    char parseGoodChar;         // Character to display for string parsed and successful operation

    Profile* viewProfile;       // Used by "profile view xxx" command, switch the profile display to this profile if not NULL, otherwise view the current RAM frame
    int viewProfileNum;         // Index of the profile being viewed

    FreezeFrame* freeze;        // Used by "view freeze" command, display this freezeFrame over serial if not NULL, otherwise view the current RAM frame

    bool timeSynced;            // Used to check whether or not RTC time has been synchronized with the AMS (master clock source)
    void* wdtThreadId;          // ID to access the watchdog check-in thread
};

#endif
