#ifndef DEFAULT_PROFILE_H
#define DEFAULT_PROFILE_H

#include "Profile.h"

// The default flash configuration object, used as backup/failsafe in case other profiles are corrupted
Profile defaultProfile = {
    -2,         // GLV charging current limit
    5,          // GLV discharging current limit
    1.4,        // GLV battery nominal capacity (Ah)
    50,         // GLV battery current filter taps
    
    1.0,        // DC-DC turn-on threshold current
    20,         // DC-DC over current limit
    1,          // DC-DC start-up delay
    1,          // DC-DC stop delay
    50,         // DC-DC current filter taps
    
    10,         // IMD Latch soft-delay on startup
    10,         // AMS Latch soft-delay on startup
    60,         // Interal over-temp
    
    true,       // CAN noack
    true,       // Extended serial display
    
    CAN_TX_SIZE,        // CAN tx size
    CAN_RX_SIZE,        // CAN rx size
    SERIAL_BAUD,        // Serial port baudrate
    TX_SIZE,            // Serial tx buffer size
};

#endif
