#include "KS0108.h"
#include "Buffers.h"

// Macro for printing to screen; Where y is the start poition of the text, and y2 is the start position of the variable
#define PUT2SCREEN(string, var, unit, x, y, y2)   display.PutString(x, y,  string);   display.PutString(x, y2, var);   display.PutString(x,y2+15,unit);

#define HOME_SCREEN     0
#define BATTERY_SCREEN  1
#define MOTOR_SCREEN    2
#define SYS_MGMT_SCREEN 3
#define CHARGE_SCREEN   4
#define FAULT_SCREEN    5



// Initialize Variables
int  CurrScreen = HOME_SCREEN;
int  PrevScreen = !CurrScreen;

// Defines the pins for the dsiplay. These are hardwired.
KS0108 display(p26, p21, p22, p23, p25, p24, p8, p7, p6, p5, p13, p14, p12, p11);

void DisplayHomeScreen()
{
    display.ClearScreen();
    display.PutString(0, 54, "Home");

    //Info line 1: Battery Life & Vehicle Speed
    PUT2SCREEN("BatLife:",  BigBatLifeBuffer,   "%",   1,  0, 39);
    PUT2SCREEN(",",         SmallBatLifeBuffer, "%",   1, 59, 62);
    PUT2SCREEN("Spd:",      CarSpdBuffer,       "",    1, 89,108);

    //Info line 2: Average Battery Temp & Peak Battery Temp
    PUT2SCREEN("AvgBatT:",  AvgBatTBuffer,   "F",      3,  0, 39);
    PUT2SCREEN("PkBatT:",   MaxBatTBuffer,   "F",      3, 69,103);

    //Info line 3: Left Motor Temp & Right Motor Temp
    PUT2SCREEN("LMtTmp:",   LMtrTmpBuffer,   "F",      5,  0, 34);
    PUT2SCREEN("RMtTmp:",   RMtrTmpBuffer,   "F",      5, 69,103);

    //Fault line
    display.PutString(7, 14, "Reserved for faults");
}

void DisplayBatteryScreen()
{
    display.ClearScreen();
    display.PutString(0, 34, "Main Battery");

    //Info line 1: Battery Voltage, Power & Current
    PUT2SCREEN("V:",        BigBatVoltBuffer,       "V",    1,   0, 10);
    PUT2SCREEN("P:",        BigBatPowerBuffer,      "W",    1,  45, 55);
    PUT2SCREEN("I:",        BigBatCurrentBuffer,    "A",    1,  90,100);

    //Info line 2: High, Low, & Average Cell Voltage
    PUT2SCREEN("Vmx:",      VmaxBuffer,             "V",    3,   0, 20);
    PUT2SCREEN("Vmn:",      VminBuffer,              "",    3,  47, 67);
    PUT2SCREEN("Vav:",      VavgBuffer,              "",    3,  88,108);

    //Info line 3: High, Low, & Average Cell Temp
    PUT2SCREEN("Tmx:",        MaxBatTBuffer,       "F",     5,  0, 20);
    PUT2SCREEN("Tmn:",        MinBatTBuffer,        "",     5, 47, 67);
    PUT2SCREEN("Tav:",        AvgBatTBuffer,        "",     5, 88,108);

    //Info line 4: Highest Board Temp
    PUT2SCREEN("HighBoardTemp:",  BoardTempBuffer,   "F",   7,  17, 87);
}

void DisplayMotorScreen()
{
    display.ClearScreen();
    display.PutString(0, 52, "Motor");

    //Info line 1: Left Motor Temp & Right Motor Temp
    PUT2SCREEN("LMtTmp:",  LMtrTmpBuffer,   "F",      1,  0, 34);
    PUT2SCREEN("RMtTmp:",  RMtrTmpBuffer,   "F",      1, 64, 98);

    //Info line 2: Left & Right Air Temp
    PUT2SCREEN("LAirTp:",    LAirTmpBuffer,  "F",     2,  0, 34);
    PUT2SCREEN("RairTp:",    RAirTmpBuffer,  "F",     2, 64, 98);

    //Info line 3: Left & Right IGBT Temp
    PUT2SCREEN("LIGBTp:",    LIGBTmpBuffer,  "F",     3,  0, 34);
    PUT2SCREEN("RIGBTp:",    RIGBTmpBuffer,  "F",     3, 64, 98);

    //Info line 4: Left & Right Motor RPM
    PUT2SCREEN("Rpm-L:",      Rpm_LBuffer,      "",     5,  0, 30);
    PUT2SCREEN("Rpm-R:",      Rpm_RBuffer,      "",     5, 77,107);

    //Info line 5: Torque Request (Throttle)
    PUT2SCREEN("Torque Request:", TRequestBufferL, "%",    7,  0, 75);
    PUT2SCREEN(",",               TRequestBufferR, "%",    7, 95, 98);
}

void DisplaySysMgmtScreen()
{
    display.ClearScreen();
    display.PutString(0, 22, "System Management");

    //Info line 1: Small Battery Current & Shutdown Switch State
    PUT2SCREEN("I_GLV:",      SmallBatCurrentBuffer,"A",         1,  0, 30);
    PUT2SCREEN("ShtdSwtch:",  ShtdSwtchBuffer,       "",         1, 58,108);

    //Info line 2: Fan Duty Cycle
    PUT2SCREEN("Fan-1:",      Fan1Buffer,      "",     3,  0, 30);
    PUT2SCREEN("Fan-2:",      Fan2Buffer,      "",     3, 77,107);

    //Info line 3: Pump Duty Cycle
    PUT2SCREEN("Pump1:",      Pump1Buffer,      "",     5,  0, 30);
    PUT2SCREEN("Pump2:",      Pump2Buffer,      "",     5, 77,107);

    //Info line 4: DCDC & IMD Status
    PUT2SCREEN("DCDC :",      DCDCBuffer,      "",     7,  0, 30);
    PUT2SCREEN(" IMD :",      IMDRBuffer,      "",     7, 52,82);
}

void DisplayFaultScreen()
{
    display.ClearScreen();
    display.PutString(0, 49, "Faults");

    //Info line 1: Battery Voltage, Power & Current
    PUT2SCREEN("",   Fault1Buffer,  "",    1,   0, 0);
    PUT2SCREEN("",   Fault1Buffer,  "",    2,   0, 0);
    PUT2SCREEN("",   Fault1Buffer,  "",    3,   0, 0);
    PUT2SCREEN("",   Fault1Buffer,  "",    4,   0, 0);
    PUT2SCREEN("",   Fault1Buffer,  "",    5,   0, 0);
    PUT2SCREEN("",   Fault1Buffer,  "",    6,   0, 0);
    PUT2SCREEN("",   Fault1Buffer,  "",    7,   0, 0);
}

void DisplayChargeScreen()
{
    display.ClearScreen();
    display.PutString(0, 44, "CHARGING");

    // Battery Voltage, Charge Current, & Source Voltage
    PUT2SCREEN("Battery Voltage :",   BigBatVoltBuffer,  "V",    1,   9, 94);
    PUT2SCREEN("Charging Current:",   ChargeCurrBuffer,  "V",    3,   9, 94);
    PUT2SCREEN("Source Voltage :",    SourceVBuffer,     "F",    5,  12, 92);
}

void ToggleScreen()
{
    CurrScreen = (CurrScreen+1) %5;
}

void DisplayCurrScreen(void const *args)
{
    while(1) {
        if(PrevScreen != CurrScreen) {
            switch(CurrScreen) {
                case 0:
                    DisplayHomeScreen();
                    break;
                case 1:
                    DisplayBatteryScreen();
                    break;
                case 2:
                    DisplayMotorScreen();
                    break;
                case 3:
                    DisplaySysMgmtScreen();
                    break;
                case 4:
                    DisplayChargeScreen();
                    break;
                case 5:
                    DisplayFaultScreen();
                    break;
                default:
                    break;
            }
            PrevScreen = CurrScreen;
        }
        Thread::yield();
    }
    
}