#ifndef _STEERING_H
#define _STEERING_H

#include "mbed.h"
#include <math.h>
#include "rtos.h"
#include "KS0108.h"
#include "Arial14.h"
#include "Screens.h"
#include "CANQueue.h"
#include "CANBuffer.h"
#include "PCM_CAN_IDs.h"
#include "AMS_CAN_IDs.h"
#include "SYS_MGMT_CAN_IDs.h"
#include "Charger_CAN_IDs.h"
#include "Steering_Wheel_CAN_IDs.h"

#define GetFloat  *(float*)((void*)(&Rxmsg.data[0]))
#define GetFloat4 *(float*)((void*)(&Rxmsg.data[4]))
#define GetFloat8 *(float*)((void*)(&Rxmsg.data[8]))

#define BLButtonGreen   DigitalOut l3(P1_24,1);  DigitalOut l4(P0_24,0);  // SW6,  SW8  respectively
#define BLButtonRed     DigitalOut l3(P1_24,0);  DigitalOut l4(P0_24,1);

#define BRButtonGreen   DigitalOut l1(P1_28,1);  DigitalOut l2(P1_26,0);  // SW2,  SW4  respectively
#define BRButtonRed     DigitalOut l1(P1_28,0);  DigitalOut l2(P1_26,1);

#define TLButtonGreen   DigitalOut u3(P1_4,0);   DigitalOut u4(P1_0,1);   // SW13, SW15 respectively
#define TLButtonRed     DigitalOut u3(P1_4,1);   DigitalOut u4(P1_0,0);

#define TRButtonGreen   DigitalOut u1(P1_14,0);  DigitalOut u2(P1_9,1);   // SW9,  SW11 respectively
#define TRButtonRed     DigitalOut u1(P1_14,1);  DigitalOut u2(P1_9,0);

float pi =                  3.14159;
float WheelRadius =         5.0/6.0;              // In feet; same as 10 inches
float WheelCircumference =  2.0*pi*WheelRadius; //In feet     

Serial pc(USBTX,USBRX);

CANBuffer SteeringCANPort(CAN1, MEDIUM, P3_26);    // Initialize the CAN port/pin

AnalogOut LEDBar(p18);

DigitalOut boSW1(P1_29,1);//            SW1   
DigitalIn biSWBR(P1_27, PullDown);//    SW3,  BRight

DigitalOut boSW5(P1_25,1);//            SW5
DigitalIn biSWBL(P1_22, PullDown);//    SW7,  BLeft

DigitalOut boSW10(P1_10,1);//           SW10
DigitalIn biSWTR(P1_8, PullDown);//     SW12, TRight

DigitalOut boSW14(P1_1,1);//            SW14
DigitalIn biSWTL(P0_25, PullDown);//    SW16, TLeft

#endif //_STEERING_H