#include "Steering.h"
// To-Do:
// Look at SYS management CAN translations: shutdown switches, DCDC status, & IMD (this is a resistance, in ohms)
// Figure out screen/variable updating options (hardware filter), NVIC_SetPriority(CAN_IRQn,####)LPC17xx.h
// Firgure out fault protocall

void Init();
void ProcessButtons(void const *args);
void RequestStatusChange();
void ResetSteeringWheel();
void ResetCar();
void ProcessCANMsg(CANMessage& msg);
void UpdateDisplay();
void ProcessButtons(void const *args);
void ConnectedStatusCANMsg();

float CANFloat;
float CANFloat2;
Ticker StatusMsg;

int main()
{
    Init();

    CANMessage Rxmsg;

    Thread Thread2(ProcessButtons);
    Thread Thread1(DisplayCurrScreen);

    while(1) {
        if (SteeringCANPort.rxRead(Rxmsg)) {
            ProcessCANMsg(Rxmsg);
        }
        else
            Thread::yield();
    }
}


void Init()
{
    StatusMsg.attach(&ConnectedStatusCANMsg,0.1);
    pc.baud(921600);
    BLButtonRed;
    BRButtonGreen;
    TLButtonGreen;
    TRButtonGreen;
    //initialize screen Startup Process
    wait(2);
}


void ProcessButtons(void const *args)
{
    while(1) {
        Thread::wait(50);
        if(biSWBR.read()) {
            Thread::wait(750);
            if (biSWBR.read()) {
                ResetCar();
            }
            NVIC_SystemReset();
            ResetSteeringWheel();
        }

        if(biSWBL.read()) {
            Thread::wait(1000);
            if (biSWBL.read()) {
                RequestStatusChange();
            }
        }

        if(biSWTR.read() && CurrScreen != 5) {
            //If the toggle button is pressed and the screen isn't on Fault_Screen
            ToggleScreen();
            Thread::wait(250);
        } else if (biSWTR.read() && CurrScreen == 5) {// If the screen was on Fault, go to Home
            CurrScreen = 0;
            Thread::wait(250);
        }

        if(biSWTL.read() && CurrScreen != 0) {
            //If the Home button is pressed and the screen isn't on Fault_Screen
            CurrScreen = 0;
            Thread::wait(250);
        } else if (biSWTL.read() && CurrScreen == 0) {// If the screen was on Fault, go to Home
            CurrScreen = 5;
            Thread::wait(250);
        }
    }
}


void UpdateDisplay()
{
}


void ProcessCANMsg(CANMessage& Rxmsg)
{
    if (SteeringCANPort.rxRead(Rxmsg)) {
        // Printing CAN message data:
        // printf("Message ID: 0x%x len: %d hex: 0x%x float: %f\r\n", Rxmsg.id, Rxmsg.len, *((int*)((void*)(&Rxmsg.data[0]))), *((float*)((void*)(&Rxmsg.data[0]))));
        // for (int i=0; i < Rxmsg.len; i++) printf("D[%d]: %x ", i, Rxmsg.data[i]);
        if (Rxmsg.id == AMS_MODE_ID) {
            if(Rxmsg.data[0] != (1<<3))
                DriveStatusRequestBuffer=1;
            else
                DriveStatusRequestBuffer=0;
            }

        if (Rxmsg.id == AMS_POWER_ID) {
            CANFloat = GetFloat;
            LEDBar = (CANFloat/85.0)*(2.6/3.3);
        }

        switch (CurrScreen) {
            case HOME_SCREEN:
                switch (Rxmsg.id) {

                        // HOME SCREEN *******************************************************************************************
                        // Pedal Test
                        /*case PCM_PEDALS_ID:
                            CANFloat = GetFloat;
                            if (abs(CANFloat*100 - float (*AccPedalBuffer)) >= 1) {
                                sprintf(AccPedalBuffer,"%3.2d", int(CANFloat*100));
                                display.PutString(1,40,AccPedalBuffer);
                            }
                            CANFloat2 = GetFloat4;
                            if (abs(CANFloat2*100 - float (*BrkPedalBuffer)) >= 1) {
                                sprintf(BrkPedalBuffer,"%3.2d", int(CANFloat2*100));
                                display.PutString(1,60,BrkPedalBuffer);
                            }
                            break;*/

                    case AMS_SOC_ID:
                        CANFloat = GetFloat;
                        //if (abs(CANFloat*100 - *BigBatLifeBuffer) >= 1) {
                            sprintf(BigBatLifeBuffer,"%3.2d", int(CANFloat*100));                   // Big battery life percentage
                            display.PutString(1,40,BigBatLifeBuffer);
                        //}
                        break;
                    case SYS_MGMT_GLV_SOC_ID:
                        CANFloat = GetFloat;
                        //if (abs(CANFloat*100 - *SmallBatLifeBuffer) >= 1) {
                            sprintf(SmallBatLifeBuffer,"%3.2d", int(CANFloat*100));                 // Small battery life percentage
                            display.PutString(1,60,SmallBatLifeBuffer);
                        //}
                        break;
                    case PCM_FRPM_ID:
                        CANFloat  = GetFloat;
                        CANFloat2 = GetFloat4;
                        //if (abs((CANFloat+CANFloat2)*WheelCircumference*30 - *CarSpdBuffer) >= 1) {
                            sprintf(CarSpdBuffer,"%3.2d", int((CANFloat+CANFloat2)*WheelCircumference*30));     // Miles per hour
                            display.PutString(1,108,CarSpdBuffer);
                        //}
                        break;
                    case AMS_TEMP_MMA_ID_BASE:
                        CANFloat2 = GetFloat4;
                        //if (abs((CANFloat2*9.0/5.0)+32 - *MaxBatTBuffer) >=1) {
                            sprintf(MaxBatTBuffer,"%3.2d", int((CANFloat2*9.0/5.0)+32));
                            display.PutString(3,103,MaxBatTBuffer);
                        //}
                        CANFloat = GetFloat8;
                        //if (abs((CANFloat*9.0/5.0)+32 - *AvgBatTBuffer) >=1) {
                            sprintf(AvgBatTBuffer,"%3.2d", int((CANFloat*9.0/5.0)+32));          // Degrees F
                            display.PutString(3,39,AvgBatTBuffer);
                        //}
                        break;
                    case PCM_MOTEMP_ID:
                        CANFloat = GetFloat;
                        //if (abs((CANFloat*9.0/5.0)+32 - *LMtrTmpBuffer) >= 1) {
                            sprintf(LMtrTmpBuffer,"%3.2d", int((CANFloat*9.0/5.0)+32));
                            display.PutString(5,34,LMtrTmpBuffer);
                        //}
                        CANFloat2 = GetFloat4;
                        //if (abs((CANFloat2*9.0/5.0)+32 - *RMtrTmpBuffer) >= 1) {
                            sprintf(RMtrTmpBuffer,"%3.2d", int((CANFloat2*9.0/5.0)+32));
                            display.PutString(5,34,RMtrTmpBuffer);
                        //}
                        break;
                    default:
                        break;
                }
                break;
                // BATTERY SCREEN***********************************************************************************
            case BATTERY_SCREEN:
                switch (Rxmsg.id) {
                    case AMS_VOLTAGE_ID:
                        CANFloat = GetFloat;
                        //if (abs(CANFloat - *BigBatVoltBuffer) >= 0.1) {
                            sprintf(BigBatVoltBuffer,"%3.2d", int(CANFloat));                       // Volts
                            display.PutString(1,10,BigBatVoltBuffer);
                        //}
                        break;
                    case AMS_POWER_ID:
                        CANFloat = GetFloat;
                        LEDBar = (CANFloat/85.0)*(2.6/3.3);
                        //if (abs(CANFloat - *BigBatPowerBuffer) >= 1) {
                            sprintf(BigBatPowerBuffer,"%3.2d", int(CANFloat));                       // Watts
                            display.PutString(1,55,BigBatPowerBuffer);
                        //}
                        break;
                    case AMS_CURRENT_ID:
                        CANFloat = GetFloat;
                        //if (abs(CANFloat - *BigBatCurrentBuffer) >= 0.2) {
                            sprintf(BigBatCurrentBuffer,"%3.2d", int(CANFloat));                       // Amps
                            display.PutString(1,100,BigBatCurrentBuffer);
                        //}
                        break;
                    case AMS_CELLV_MMA_ID_BASE:
                        CANFloat2 = GetFloat4;
                        //if (abs(CANFloat2 - *VmaxBuffer) >= 0.1) {
                            sprintf(VmaxBuffer,"%3.2d", int(CANFloat2));
                            display.PutString(3,20,VmaxBuffer);
                        //}
                        CANFloat = GetFloat;
                        //if (abs(CANFloat - *VminBuffer) >= 0.1) {
                            sprintf(VminBuffer,"%3.2d", int(CANFloat));
                            display.PutString(3,67,VminBuffer);
                        //}
                        CANFloat = GetFloat8;
                        //if (abs(CANFloat - *VavgBuffer) >= 0.1) {
                            sprintf(VavgBuffer,"%3.2d", int(CANFloat));                                 // Volts
                            display.PutString(3,108,VavgBuffer);
                        //
                        break;
                    case AMS_TEMP_MMA_ID_BASE:
                        CANFloat = GetFloat;
                        //if (abs((CANFloat*9.0/5.0)+32 - *MinBatTBuffer) >= 1) {
                            sprintf(MinBatTBuffer,"%3.2d", int((CANFloat*9.0/5.0)+32));
                            display.PutString(5,67,MinBatTBuffer);
                        //}
                        CANFloat2 = GetFloat4;
                        //if (abs((CANFloat2*9.0/5.0)+32 - *MaxBatTBuffer) >=1) {
                            sprintf(MaxBatTBuffer,"%3.2d", int((CANFloat2*9.0/5.0)+32));
                            display.PutString(5,20,MaxBatTBuffer);
                        //}
                        CANFloat = GetFloat8;
                        //if (abs((CANFloat*9.0/5.0)+32 - *AvgBatTBuffer) >=1) {
                            sprintf(AvgBatTBuffer,"%3.2d", int((CANFloat*9.0/5.0)+32));          // Degrees F
                            display.PutString(5,108,AvgBatTBuffer);
                        //}
                        break;
                    case AMS_BOARDTEMP_ID:
                        CANFloat = GetFloat;
                        //if (abs((CANFloat*9.0/5.0)+32 - *BoardTempBuffer) >= 1) {
                            sprintf(BoardTempBuffer,"%3.2d", int((CANFloat*9.0/5.0)+32));                                 // Degrees F
                            display.PutString(7,87,BoardTempBuffer);
                        //}
                        break;
                    default:
                        break;
                }
                break;
                // MOTOR SCREEN*****************************************************************
            case MOTOR_SCREEN:
                switch (Rxmsg.id) {
                    case PCM_MOTEMP_ID:
                        CANFloat = GetFloat;
                        //if (abs((CANFloat*9.0/5.0)+32 - *LMtrTmpBuffer) >= 1) {
                            sprintf(LMtrTmpBuffer,"%3.2d", int((CANFloat*9.0/5.0)+32));
                            display.PutString(1,34,LMtrTmpBuffer);
                        //}
                        CANFloat2 = GetFloat4;
                        //if (abs((CANFloat2*9.0/5.0)+32 - *RMtrTmpBuffer) >= 1) {
                            sprintf(RMtrTmpBuffer,"%3.2d", int((CANFloat2*9.0/5.0)+32));
                            display.PutString(1,98,LMtrTmpBuffer);
                        //}
                        break;
                    case PCM_AIRTEMP_ID:
                        CANFloat = GetFloat;
                        //if (abs((CANFloat*9.0/5.0)+32 - *LAirTmpBuffer) >= 1) {
                            sprintf(LAirTmpBuffer,"%3.2d", int((CANFloat*9.0/5.0)+32));
                            display.PutString(2,34,LAirTmpBuffer);
                        //}
                        CANFloat2 = GetFloat4;
                        //if (abs((CANFloat2*9.0/5.0)+32 - *RAirTmpBuffer) >= 1) {
                            sprintf(RAirTmpBuffer,"%3.2d", int((CANFloat2*9.0/5.0)+32));                   // Degrees F
                            display.PutString(2,98,RAirTmpBuffer);
                        //}
                        break;
                    case PCM_IGBTTEMP_ID:
                        CANFloat = GetFloat;
                        //if (abs((CANFloat*9.0/5.0)+32 - *LIGBTmpBuffer) >= 1) {
                            sprintf(LIGBTmpBuffer,"%3.2d", int((CANFloat*9.0/5.0)+32));
                            display.PutString(3,34,LIGBTmpBuffer);
                        //}
                        CANFloat2 = GetFloat4;
                        //if (abs((CANFloat2*9.0/5.0)+32 - *RIGBTmpBuffer) >= 1) {
                            sprintf(RIGBTmpBuffer,"%3.2d", int((CANFloat2*9.0/5.0)+32));                   // Degrees F
                            display.PutString(3,98,RIGBTmpBuffer);
                        //}
                        break;
                    case PCM_RPM_ID:
                        CANFloat = GetFloat;
                        //if (abs(CANFloat - *Rpm_LBuffer) >= 1) {
                            sprintf(Rpm_LBuffer,"%3.2d", int(CANFloat));
                            display.PutString(5,30,Rpm_LBuffer);
                        //}
                        CANFloat2 = GetFloat4;
                        //if (abs(CANFloat2 - *Rpm_RBuffer) >= 1) {
                            sprintf(Rpm_RBuffer,"%3.2d", int(CANFloat2));
                            display.PutString(5,107,Rpm_RBuffer);
                        //}
                        break;
                    case PCM_TORQUERQ_ID:
                        CANFloat = GetFloat;
                        //if (abs(CANFloat*100 - *TRequestBufferL) >= 1) {
                            sprintf(TRequestBufferL,"%3.2d", int(CANFloat*100));             // Percentage
                            display.PutString(7,89,TRequestBufferL);
                        //}
                        CANFloat2 = GetFloat4;
                        //if (abs(CANFloat2*100 - *TRequestBufferR) >= 1) {
                            sprintf(TRequestBufferR,"%3.2d", int(CANFloat2*100));             // Percentage
                            display.PutString(7,89,TRequestBufferR);
                        //}
                        break;
                    default:
                        break;
                }
                break;

                // SYSTEM MANAGEMENT SCREEN***************************************************
            case SYS_MGMT_SCREEN:
                switch (Rxmsg.id) {
                    case SYS_MGMT_GLV_CURRENT_ID:
                        CANFloat = GetFloat;
                        //if (abs(CANFloat - *SmallBatCurrentBuffer) >= 0.2) {
                            sprintf(SmallBatCurrentBuffer,"%3.2d", int(CANFloat));             // Amps
                            display.PutString(1,30,SmallBatCurrentBuffer);
                        //}
                        break;
                    case SYS_MGMT_SWITCHES_ID:
                        CANFloat = GetFloat;
                        sprintf(ShtdSwtchBuffer,"%3.2d", int(CANFloat));             // How the heck are we interpreting this data
                        display.PutString(1,108,ShtdSwtchBuffer);
                        break;
                    case SYS_MGMT_PWM_FAN_ID:
                        CANFloat = GetFloat;
                        //if (abs(CANFloat*100 - *Fan1Buffer) >= 1) {
                            sprintf(Fan1Buffer,"%3.2d", int(CANFloat*100));
                            display.PutString(3,30,Fan1Buffer);
                        //}
                        CANFloat2 = GetFloat4;
                        //if (abs(CANFloat2*100 - *Fan1Buffer) >= 1) {
                            sprintf(Fan2Buffer,"%3.2d", int(CANFloat2*100));
                            display.PutString(3,107,Fan2Buffer);
                        //}
                        break;
                    case SYS_MGMT_PWM_PUMP_ID:
                        CANFloat = GetFloat;
                        //if (abs(CANFloat*100 - *Pump1Buffer) >= 1) {
                            sprintf(Pump1Buffer,"%3.2d", int(CANFloat*100));
                            display.PutString(5,30,Pump1Buffer);
                        //}
                        CANFloat2 = GetFloat4;
                        //if (abs(CANFloat2*100 - *Pump2Buffer) >= 1) {
                            sprintf(Pump2Buffer,"%3.2d", int(CANFloat2*100));
                            display.PutString(5,107,Pump2Buffer);
                        //}
                        break;
                    case SYS_MGMT_DCDC_STATUS_ID:
                        CANFloat = GetFloat;
                        sprintf(DCDCBuffer,"%3.2d", int(CANFloat));             // How the heck are we interpreting this data
                        display.PutString(7,30,DCDCBuffer);
                        break;
                    case SYS_MGMT_IMD_RESIST_ID:
                        CANFloat = GetFloat;
                        //if (abs(CANFloat - *IMDRBuffer) >= 1) {
                            sprintf(IMDRBuffer,"%3.2d", int(CANFloat));
                            display.PutString(7,82,IMDRBuffer);
                        //}
                        break;
                    default:
                        break;
                }
                break;

                // CHARGE SCREEN *************************************************************
            case CHARGE_SCREEN:
                switch (Rxmsg.id) {
                    case CHARGER_CHARGING_CURRENT_ID:
                        CANFloat = GetFloat;
                        //if (abs(CANFloat - *ChargeCurrBuffer) >= 0.1) {
                            sprintf(ChargeCurrBuffer,"%3.2d", int(CANFloat));                       // Amps
                            display.PutString(3,94,ChargeCurrBuffer);
                        //}
                        break;
                    case CHARGER_CHARGING_VOLTAGE_ID:
                        CANFloat = GetFloat;
                        //if (abs(CANFloat - *BigBatVoltBuffer) >= 0.1) {
                            sprintf(BigBatVoltBuffer,"%3.2d", int(CANFloat));                       // Volts
                            display.PutString(3,94,BigBatVoltBuffer);
                        //}
                        break;
                    default:
                        break;
                }
                break;
            default:
                break;
        }
    }
}

void ConnectedStatusCANMsg()
{
    CANMessage ConnectedStatus(STEERING_WHEEL_STATUS_ID, &ConnectedStatusBuffer,1);
    SteeringCANPort.txWrite(ConnectedStatus);
}


void RequestStatusChange()
{
    CANMessage TxDriveStatusRequest(STEERING_WHEEL_DRIVE_STATUS_REQUEST_ID , &DriveStatusRequestBuffer,1);
    for (int j=0; j<10; j++) {
        SteeringCANPort.txWrite(TxDriveStatusRequest);
    }
    display.PutString(7,0,"    DRIVE REQUEST SENT    ");
    Thread::wait(750);
    PrevScreen = !CurrScreen; // To force a screen update
}


void ResetSteeringWheel()
{
    NVIC_SystemReset();
}


void ResetCar()
{
    CANMessage TxCarReset(STEERING_WHEEL_CAR_RESET_ID,&TxResetBuffer,1);
    for (int k=0; k<10; k++) {
        SteeringCANPort.txWriteDirect(TxCarReset);
    }
}