/*
Steering.cpp
#include "Steering.h"

bool NOT_biSWBL_HELD;
bool NOT_biSWTR_HELD;

void update_display(void const *args){
    
    while(true){
        
        if(screen_flags[curr_screen] || should_redraw){
        screen_flags[curr_screen] = 0;
        should_redraw = false;
        switch(curr_screen){
    
            case HOME_SCREEN:{
                
                display.ClearScreen();
                display.SelectFont(Arial10,BLACK,ReadData);
                display.GotoXY(37,0);
                display.PrintString(" Home Screen");
                
                printf("Battery Voltage: %d\n\r", vars_list->get_value(PCM_STATE_ID));
              
                display.GotoXY(16,16);
                if(vars_list->get_value(PCM_STATE_ID) == 0){
                    display.PutString(3, 30, "Drive Status: OFF");
                }
                else{
                    display.PrintString("Drive Status: ON");
                }
                break;
                }
            
            case BATTERY_SCREEN:
            
                display.ClearScreen();
                display.SelectF ont(Arial10,BLACK,ReadData);
                display.GotoXY(33,0);
                display.PrintString(" Battery Screen");
                break;
        
            default:
                break;    
        
            }
        }
        wait(2);   
    }
}

void toggle_screen(){
    should_redraw = true;
    curr_screen = (curr_screen+1) % NUM_SCREEN; 
}

void request_status_change(){
    
    char drive_status_request;
    ds_mutex.lock();
    drive_status_request = !(vars_list->get_value(PCM_STATE_ID));

    ds_mutex.unlock();
    char * status_string;

    if(drive_status_request){
        status_string = "ON";
    }
    else{
        status_string = "OFF";
    }

    CANMessage Txmsg_drive_status_request(0x501,&drive_status_request,1);//Encode Tx messages
    for(int i = 0; i < 10; i++){
        CAN_Steering_Buffer.txWrite(Txmsg_drive_status_request);
    }

    printf("%s\n\r", status_string);
    return;
}

void reset()
{
    reset_body = 1;
    CANMessage Txmsg_reset(0x502,&reset_body,1);                        //Encode Tx messages
    for(int i = 0; i < 10; i++){
        CAN_Steering_Buffer.txWriteDirect(Txmsg_reset);
    }
    NVIC_SystemReset();
    display.ClearScreen();
    display.SelectFont(Arial12,BLACK,ReadData);
    display.GotoXY(16,16);
    printf("Reset Initiated\n\r");

    return;
}    

void Init()
{
    should_redraw = true;
    pc.baud(921600);
    curr_screen = HOME_SCREEN;
    drive_status = 0;
    drive_status_request = 1;
    reset_body = 0;
    ledstream.write(0);
    NOT_biSWBL_HELD = true;
    NOT_biSWTR_HELD = true;
    
    vars_list = new variables();//Avoid Heap
    
    vars_list->add(PCM_STATE_ID, HOME_SCREEN);
    vars_list->add(BATTERY_VOLTAGE_ID, BATTERY_SCREEN);
    vars_list->add(BATTERY_POWER_ID, BATTERY_SCREEN);
    vars_list->add(BATTERY_CURRENT_ID, BATTERY_SCREEN);
    
}

void read_messages(void const *args) {
    
    while (true) {
        
        CANMessage Rxmsg;
        if(CAN_Steering_Buffer.rxRead(Rxmsg)){
            id_node = vars_list->get_node(Rxmsg.id);
            if(id_node != NULL){
                if(id_node->value != Rxmsg.data[0]){
                    screen_flags[id_node->screen] = 1;  
                }
                id_node->value = Rxmsg.data[0];
            }
        }
    }
}

int main(){
    // Initialize, set all variables.
    Init();
    wait(0.1);
    
    //Init Display
    display.GotoXY(10,16);
    display.SelectFont(Arial_14,BLACK,ReadData);
    display.PrintString("Penn Electric Racing");
    CAN_Steering_Buffer.mode(NoAck);
    
    wait(0.5);
     
     //New thread to read messages.
    Thread update_thread(read_messages);                                //Prioritise
        
    // display the screen.
    Thread display_thread(update_display);                              //Prioritise
      

    // Start to read buttons on main thread
    while(1)
    {
       // Thread::wait(100);
        if(biSWBL.read() && NOT_biSWBL_HELD){
            request_status_change();
            NOT_biSWBL_HELD = false;
        }
        
        else if(!biSWBL.read()){
            NOT_biSWBL_HELD = true;
        }
        
        else{
            // ignore BiSWBL.read()
        }
        
        if(biSWTR.read() && NOT_biSWTR_HELD){
            toggle_screen();
            NOT_biSWTR_HELD = false;
        }
        
        else if(!biSWTR.read()){
            NOT_biSWTR_HELD = true;
        }
        
        else{
            // ignore BiSWTR.read()
        }
        
        if(biSWBR.read()){ 
            reset();
        }
    }        
}

--------------------------------------------------------------------------------------------------------------
Steering.h
#ifndef _STEERING_H
#define _STEERING_H

#include "mbed.h"
#include "rtos.h"
#include "KS0108.h"

#include "Arial10.h"
#include "Arial12.h"
#include "Arial14.h"
#include "Comic24.h"
#include "vivaldi16.h"
#include "CANBuffer.h"
#include "variables.h"


#include "LPCDigitalIn.h"

#define SWITCH_ID 410

#define BATTERY_VOLTAGE_ID 0x304
#define BATTERY_POWER_ID 0x306
#define BATTERY_CURRENT_ID 0x305

#define PCM_STATE_ID 0x201

#define BATTERY_MIN_CELLVOLTAGE_ID 0x301
#define BATTERY_MAX_CELLVOLTAGE_ID 0x300
#define BATTERY_AVG_CELLVOLTAGE_ID 0x302

#define BATTERY_MIN_CELLTEMPERATURE_ID 0x30A
#define BATTERY_MAX_CELLTEMPERATURE_ID 0x309
#define BATTERY_AVG_CELLTEMPERATURE_ID 0x30B
#define AMS_BATTERY_STATE 0x30E          // AIRS 7 and 6 // Precharge 3

#define NUM_SCREEN 2

#define HOME_SCREEN 0
#define BATTERY_SCREEN 1

Serial pc(USBTX,USBRX);
CANBuffer CAN_Steering_Buffer(CAN1, MEDIUM, p3_26);


KS0108 display(p26, p21, p22, p23, p25, p24, p8, p7, p6, p5, p13, p14, p12, p11); 
//Ticker call_ledstream;

LPCDigitalOut l1(p1_28,1);//    SW2
LPCDigitalOut l2(p1_26,1);//    SW4
    
LPCDigitalOut l3(p1_24,1);//    SW6
LPCDigitalOut l4(p0_24,1);//    SW8

LPCDigitalOut u1(p1_14,0);//    SW9 
LPCDigitalOut u2(p1_9,0);//     SW11

LPCDigitalOut u3(p1_4,0);//     SW13
LPCDigitalOut u4(p1_0,0);//     SW15

AnalogOut ledstream(p18);  // This appears to iniialize the pin as an analog out, and probably defaults to low.  Without this, the LED bar would have a few lights on.

//SW1 - SW3
LPCDigitalOut boSW1(p1_29,1);
LPCDigitalIn biSWBR(p1_27, PullDown);     //BRight

LPCDigitalOut boSW5(p1_25,1);
LPCDigitalIn biSWBL(p1_22, PullDown);     //BLeft

LPCDigitalOut boSW10(p1_10,1);
LPCDigitalIn biSWTR(p1_8, PullDown);     //TRight

LPCDigitalOut boSW14(p1_1,1);
LPCDigitalIn biSWTL(p0_25, PullDown);    //TLeft

typedef union convert{
        float FLOAT;
        char C_FLOAT[4];
        }ftc;

char SwitchName[15][13]={
    "fuse",
    "ams",
    "imd",
    "pcm",
    "brkp",
    "lft",
    "intl",
    "brko",
    "ckpt",
    "rgt",
    "hvd",
    "tsms"
};

int SwitchPosition[13][2]={
    {0,16},     //fuse
    {25,16},    //ams
    {50,16},    //imd
    {70,16},    //pcm
    {93,16},    //brkp
    {117,16},   //lft
    {0,32},     //intl
    {17,32},    //brko
    {42,32},    //ckpt
    {65,32},    //rgt
    {81,32},    //hvd
    {102,32},   //tsm
    };
    
int curr_screen;
int screen_flags[NUM_SCREEN]; 
bool should_redraw;

char drive_status;
char drive_status_request;
char reset_body;

node * id_node = NULL;
variables * vars_list;


Mutex ds_mutex;

/*
void read_messages(void const *args) {
    
    while (true) {
        CANMessage Rxmsg;
     
        if(CAN_Steering_Buffer.rxRead(Rxmsg))
            if(Rxmsg.id == PCM_STATE_ID){
              
                // Mutex to protex shared variables
                ds_mutex.lock();
                drive_status = Rxmsg.data[0];
                ds_mutex.unlock();
            }
            
            if(Rxmsg.id == BATTERY_POWER_ID)
            {
                float power_ratio;
                ftc rcv;
                rcv.FLOAT=0.0;
                
                for(int i=0; i<4; i++){
                    rcv.C_FLOAT[i] = Rxmsg.data[i];
                }
                power_ratio=rcv.FLOAT/80000;
                ledstream.write(power_ratio);
            }
        }
    }
*/

#endif /* STEERING_H */    
-----------------------------------------------------------------------------------------------------------------------------
Variables.h
#include "node.h"

class variables{
    
    public:
    
        variables();
        ~variables();
        void add(int i, int s);
        int get_screen(int i);
        char get_value(int i);
        int set_value(int i, char v);
        node * get_node(int i);
        
    
        int size;
        node * head;
        node * tail;

};

variables::variables(){
    size = 0;
    head = NULL;
    tail = NULL;
}

variables::~variables(){

    node * curr = head;
    node * next = head;
    
    while(curr != NULL){
        next = curr->next;
        delete(curr);
        curr = next;
    }
    
    head =  NULL;
    tail = NULL;
    size = 0;
}

void variables::add(int i, int s){
    
    if(head == NULL){
        head = new node(i, s);
        tail = head;
    }
    
    else{
        tail->next = new node(i,s);
        tail = tail->next;
    }
    size++;
}

node * variables::get_node(int i){

    node * curr = head;
    
    while(curr != NULL){
        if(curr->id == i){
            return curr;
        }
        else{
            curr = curr->next;
        }
    }
    return NULL;
}    

int variables::get_screen(int i){

    node * curr = head;
    
    while(curr != NULL){
        if(curr->id == i){
            return curr->screen;
        }
        else{
            curr = curr->next;
        }
    }
    return -1;
}

int variables::set_value(int i, char v){

    node * curr = head;
    
    while(curr != NULL){
        if(curr->id == i){
            curr->set_val(v);
            return 0;
        }
        else{
            curr = curr->next;
        }
    }
    return -1;
}

char variables::get_value(int i){

    node * curr = head;
    
    while(curr != NULL){
        if(curr->id == i){
            return curr->value;
        }
        else{
            curr = curr->next;
        }
    }
    return 0;
}
--------------------------------------------------------------------------------------------------------------
Node.h
class node{
    
    public:
    
        node();
        node(int id, int screen);
        void set_val(char v);
        ~node();
        
        int screen;
        int id;
        char value;
        node * next;
        
};

node::node(){
    screen = 0;
    id = 0;
    next = NULL;
}

node::node(int i, int s){
    id = i;
    screen = s;
    next = NULL;
}

void node::set_val(char v){
    value = v;
}

node::~node(){
}
*/