/*
Code by Parth Patel, Penn Electric Racing 2014, 9/23/2014
 
This library provides an easy to use, buffered, hardware-filtered CAN interface for
high performance CAN applications.  Provides automatic reception of messages via CAN RX interrupt
into a rx ring buffer.  Provides automatic transmission of messages via CAN TX interrupt.
 
@File CAN_Filter_LUT.h: Contains the formatted lookup tables to program the onboard CAN acceptance filters
 
*/
#ifndef _FILE_CAN_FILTER_LUT_H
#define _FILE_CAN_FILTER_LUT_H

#include "PCM_CAN_IDs.h"
#include "AMS_CAN_IDs.h"
#include "SYS_MGMT_CAN_IDs.h"

#define STDMASK 0x7FF
#define EXTMASK 0x1FFFFFFF
 
// These arrays defines the CAN Controller Acceptance Filter Lookup Table.
// Follow notes below or else the chip's behaviour will be undefined
// MAX SIZE PERMITTED = 512 32bit ints total across all tables
// Note that AF_LUT_SEI is 16bit, divide #entries by 2 for this one
// Note that AF_LUT_EIR is 64bit, multipy #entries by 2 for this one
 
const uint16_t AF_LUT_SEI[] = {
// !! ID's MUST BE IN ASCENDING ORDER (starting at 0x00) !!
  
// STANDARD EXPLICIT IDs - CAN CONTROLLER 1
//( 0xID                            & STDMASK),

( PCM_RPM_ID                        & STDMASK), // 0x211

( PCM_MOTEMP_ID                     & STDMASK), // 0x212

( PCM_AIRTEMP_ID                    & STDMASK), // 0x213

( PCM_IGBTTEMP_ID                   & STDMASK), // 0x214

( PCM_PEDALS_ID                     & STDMASK), // 0x220

( PCM_FRPM_ID                       & STDMASK), // 0x222

( PCM_TORQUERQ_ID                   & STDMASK), // 0x231

( AMS_FAULTCODE_ID                   & STDMASK), // 0x300

( AMS_MODE_ID                        & STDMASK), // 0x301

( AMS_CURRENT_ID                     & STDMASK), // 0x306

( AMS_CHARGECURR_ID                  & STDMASK), // 0x307

( AMS_VOLTAGE_ID                     & STDMASK), // 0x308

( AMS_SOC_ID                         & STDMASK), // 0x30B

( AMS_BOARDTEMP_ID                   & STDMASK), // 0x30E

( AMS_CELLV_MMA_ID_BASE              & STDMASK), // 0x316

//( CELLV_MMA_ID_BASE2             & STDMASK), // 0x317

( AMS_TEMP_MMA_ID_BASE               & STDMASK), // 0x318

//( TEMP_MMA_TX_ID_BASE2              & STDMASK), // 0x319

( SYS_MGMT_GLV_CURRENT_ID                & STDMASK), // 0x510

( SYS_MGMT_GLV_SOC_ID                    & STDMASK), // 0x513

( SYS_MGMT_DCDC_STATUS_ID                & STDMASK), // 0x521

( SYS_MGMT_PWM_FAN_ID                    & STDMASK), // 0x530

( SYS_MGMT_PWM_PUMP_ID                   & STDMASK), // 0x531

( SYS_MGMT_IMD_RESIST_ID                 & STDMASK), // 0x541

( SYS_MGMT_SWITCHES_ID                   & STDMASK) // 0x560
  
// STANDARD EXPLICIT IDs - CAN CONTROLLER 2
//( 0xID                              & STDMASK),

};
 
const uint32_t AF_LUT_SIR[] = {
// !! ID's MUST BE IN ASCENDING ORDER (starting at 0x00), NO OVERLAPPING RANGES !!
 
// STANDARD ID RANGES - CAN CONTROLLER 1
//( 0xLOWERBOUND & STDMASK) << 16         | ( 0xUPPERBOUND & STDMASK),          lower/upperbounds are inclusive
 
// STANDARD ID RANGES - CAN CONTROLLER 2
//( 0xLOWERBOUND & STDMASK | 1<<13) << 16 | ( 0xUPPERBOUND & STDMASK | 1<<13),  lower/upperbounds are inclusive
//( 0x400        & STDMASK | 1<<13) << 16 | ( 0x4FF        & STDMASK | 1<<13),  // Index1
};
 
const uint32_t AF_LUT_EEI[] = {
// !! ID's MUST BE IN ASCENDING ORDER (starting at 0x00) !!
 
// EXTENDED EXPLICIT IDs - CAN CONTROLLER 1
//( 0xID                              & EXTMASK),
 
// EXTENDED EXPLICIT IDs - CAN CONTROLLER 2
//( 0xID                              & EXTMASK) | 1<<29,
};
 
const uint64_t AF_LUT_EIR[] = {
// !! ID's MUST BE IN ASCENDING ORDER (starting at 0x00), NO OVERLAPPING RANGES !!

// EXTENDED ID RANGES - CAN CONTROLLER 1
//( 0xLOWERBOUND & EXTMASK) << 32         | ( 0xUPPERBOUND & EXTMASK), lower/upperbounds are inclusive
 
// EXTENDED ID RANGES - CAN CONTROLLER 2
//( 0xLOWERBOUND & EXTMASK | 1<<29) << 32 | ( 0xUPPERBOUND & EXTMASK | 1<<29), lower/upperbounds are inclusive
 
};
 
#endif