/**
 ******************************************************************************
 * @file    main.cpp
 * @author  Davide Aliprandi, STMicroelectronics
 * @version V1.0.0
 * @date    October 14th, 2015
 * @brief   mbed test application for the STMicroelectronics X-NUCLEO-IHM01A1
 *          Motor Control Expansion Board: control of 2 motors.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/

/* mbed specific header files. */
#include "mbed.h"

/* Helper header files. */
#include "DevSPI.h"

/* Component specific header files. */
#include "L6474.h"


/* Definitions ---------------------------------------------------------------*/

/* Number of steps. */
#define STEPS 100

/* Delay in milliseconds. */
#define DELAY_1 100
#define DELAY_2 3000
#define DELAY_3 4000

/* Speed in pps (Pulses Per Second).
   In Full Step mode: 1 pps = 1 step/s).
   In 1/N Step Mode:  N pps = 1 step/s). */
#define SPEED_1 2400
#define SPEED_2 1200


/* Variables -----------------------------------------------------------------*/

DigitalIn mybutton(USER_BUTTON);
bool x=true;
/* Motor Control Component. */
L6474 *motor1;
L6474 *motor2;


/* Main ----------------------------------------------------------------------*/

int main()
{
    /*----- Initialization. -----*/

    /* Initializing SPI bus. */
    DevSPI dev_spi(D11, D12, D13);

    /* Initializing Motor Control Components. */
    motor1 = new L6474(D2, D8, D7, D9, D10, dev_spi);
    motor2 = new L6474(D2, D8, D4, D3, D10, dev_spi);
    if (motor1->init() != COMPONENT_OK) {
        exit(EXIT_FAILURE);
    }
    if (motor2->init() != COMPONENT_OK) {
        exit(EXIT_FAILURE);
    }

    /* Printing to the console. */
    printf("Motor Control Application Example for 2 Motors\r\n\n");

    /*----- Moving F. -----*/
    while(true) {
        if (mybutton == 0) // Button is pressed
                {
                 x=!x;
                 printf("x =%d", x);
                }
        if (x==true) // Button is pressed
            {
            /* Printing to the console. */
            printf("--> Moving forward: M1 %d steps, M2 %d steps.\r\n", STEPS >> 1, STEPS);

            /* Moving N steps in the forward direction. */
            motor1->move(StepperMotor::FWD, STEPS >> 1);
            motor2->move(StepperMotor::FWD, STEPS >> 1);

            /* Waiting while the motor is active. */
            motor1->wait_while_active();
            motor2->wait_while_active();

            /* Getting current position. */
            int position1 = motor1->get_position();
            int position2 = motor2->get_position();
    
            /* Printing to the console. */
            printf("    Position: M1 %d, M2 %d.\r\n", position1, position2);

            /* Waiting 2 seconds. */
            wait_ms(DELAY_1);
            }
        if (x==false) // Button is pressed
            {
            /*----- Moving B. -----*/
    
            /* Printing to the console. */

            printf("--> Moving backward: M1 %d steps, M2 %d steps.\r\n", STEPS >> 1, STEPS);

    
            /* Moving N steps in the backward direction. */
            motor1->move(StepperMotor::BWD, STEPS >> 1);
            motor2->move(StepperMotor::BWD, STEPS >> 1);
    
            /* Waiting while the motor is active. */
            motor1->wait_while_active();
            motor2->wait_while_active();

            /* Getting current position. */
            int position1 = motor1->get_position();
            int position2 = motor2->get_position();
    
            /* Printing to the console. */
            printf("    Position: M1 %d, M2 %d.\r\n", position1, position2);
            printf("--> Setting Home.\r\n");


            /* Waiting 2 seconds. */
            wait_ms(DELAY_1);
            }
    }
}
