/*
================================================================================
Project:    GPS Tracker
Module:     ---
Status:     Development
Type:       .h header file
Copyright (c) 2018 Pathfindr Ltd
All Rights Reserved.
================================================================================
Notes:
================================================================================
*/
#ifndef MAIN_INTERFACE_H_
#define MAIN_INTERFACE_H_

//------------------------------------------------------------------------------
//FW DETAILS
//------------------------------------------------------------------------------ 
#define FW_VERSION          1
#define SKU                 "UWBBEACON"
#define HW_MAJORREVISION    "001"

//OPTIONS
#define USE_NRF_TEMP_SENSOR                 false

//DEFAULT VELUES
#define DEFAULT_SLEEP_FRAME                 360000 // 6 mins
#define DEFAULT_MOTION_G                    7
#define DEFAULT_MOTION_START_SECONDS        120
#define DEFAULT_MOTION_STOP_SECONDS         120
#define DEFAULT_IMPACT_G                    127
#define DEFAULT_BEACON_INTERVAL_MS          3000
#define DEFAULT_BEACON_INTERVAL_FAST_MS     100
#define DEFAULT_BEACON_POWER                4 //(accepted values are -40, -30, -20, -16, -12, -8, -4, 0, and 4 dBm)
#define DEFAULT_SETTINGSSCANTIME_MS         10000

//CONSTS
#define ONEDAYINSECONDS                     86400
#define THREEDAYSINSECONDS                  259200
#define SEVENDAYSINSECONDS                  604800
#define TENDAYSINSECONDS                    864000

//DEFAULT EVENT TIMES IN SECONDS
#define DEFAULT_INTERVAL_MOTIONCLEAR        60
#define DEFAULT_INTERVAL_RESETACCINT        10
#define DEFAULT_INTERVAL_BUTTONCLEAR        20
#define DEFAULT_INTERVAL_BATTERY            ONEDAYINSECONDS
#define DEFAULT_INTERVAL_TEMPERATURE        60
#define DEFAULT_INTERVAL_HUMIDITY           120
#define DEFAULT_INTERVAL_SETTINGSSCAN       0

//DEFINES
#define DEBUG_BUFFERSIZE                    200

//------------------------------------------------------------------------------
//mbed Libraries
//------------------------------------------------------------------------------
#include "mbed.h"
//#include "nrf_soc.h"
#include "board.h"
#include "ble/BLE.h" 

//------------------------------------------------------------------------------
//peripheral Libraries
//------------------------------------------------------------------------------
#include "WatchdogTimer.h"
#include "acd_nrf52_saadc.h"
#include "DW1000.h"
#include "MM2WayRanging.h"
#include "Lis2dh12.h"
#include "Lis2dh12_regs.h"

//------------------------------------------------------------------------------
//Application headers
//------------------------------------------------------------------------------
#include "NRFuart.h"
#include "app_data.h"
#include "LED.h"

//BLE SERVICE IDS
#define BLE_SERVICEID_PFDETECTOR2           0xfb40
#define BLE_SERVICEID_UWBBEACON             0xfb50

//------------------------------------------------------------------------------
//Global macros
//------------------------------------------------------------------------------
//#define lowByte(w) ((uint8_t) ((w) & 0xff))
//#define highByte(w) ((uint8_t) ((w) >> 8))

//------------------------------------------------------------------------------
//GLOBAL VARS
//------------------------------------------------------------------------------ 

extern bool GLOBAL_accel_healthy;
extern bool GLOBAL_requireSoftReset;
extern bool GLOBAL_debugLED;
extern bool GLOBAL_needToConfigureLis3dh;
extern time_t GLOBAL_RTCunixtime;
extern char GLOBAL_debug_buffer[DEBUG_BUFFERSIZE];
//FUNCS
extern void watchdogKick();
#endif