#include "acd_nrf52_saadc.h"

// add and remove analog channels -> +/- maxcnt

NRF52_SAADC::NRF52_SAADC(){
    NRF_SAADC->ENABLE = 1;
    memset(data, 0, sizeof(data));
    NRF_SAADC->RESULT.PTR =(uint32_t)data;
    NRF_SAADC->RESULT.MAXCNT = 0;
}

NRF52_SAADC::~NRF52_SAADC(){
    NRF_SAADC->ENABLE = 0;
}

void NRF52_SAADC::updateData(){
    NRF_SAADC->TASKS_START = 1;
    while(!NRF_SAADC->EVENTS_STARTED);
    NRF_SAADC->TASKS_SAMPLE = 1;
    for(uint8_t i = 0; i < NRF_SAADC->RESULT.MAXCNT; ++i)
    {
        while(!NRF_SAADC->EVENTS_RESULTDONE);
        while(!NRF_SAADC->EVENTS_DONE);
        while(!NRF_SAADC->EVENTS_END);
        while(NRF_SAADC->STATUS == 1); // while conversion is is progress
    }
    NRF_SAADC->TASKS_STOP = 1;
    while(!NRF_SAADC->EVENTS_STOPPED);
}

bool NRF52_SAADC::addChannel(uint8_t pin){
    if(NRF_SAADC->RESULT.MAXCNT < 8)
    {
        int channel = NRF_SAADC->RESULT.MAXCNT;
        NRF_SAADC->CH[channel].PSELP = pin;     // Input positive pin is VDD = 9
        NRF_SAADC->CH[channel].CONFIG = 0x00020000; // reset
        NRF_SAADC->RESULT.MAXCNT++;
        return 0;
    }
    return 1;
}

void NRF52_SAADC::calibrate(){
    NRF_SAADC->TASKS_CALIBRATEOFFSET = 1;
    while(!NRF_SAADC->EVENTS_CALIBRATEDONE);
}