/*
 * Made by Jurica Resetar and Karlo Milicevic @ aconno, 2017
 * jurica_resetar@yahoo.com
 * aconno.de  
 * All rights reserved 
 *
 */

#ifndef ACD_NRF52_SAADC_H
#define ACD_NRF52_SAADC_H

#include "mbed.h"

/** NRF52 adc library 
 */
class NRF52_SAADC{
    public:
        /** Initializes adc module
         */
        NRF52_SAADC();
        ~NRF52_SAADC();
        /** @returns
         *     0 on success, 1 otherwise
         */
        bool addChannel(uint8_t pin);
        void calibrate();
        /** Reads analog pins
         */
        void updateData();
        /** @returns
         *     pointer to analog input data - data is stored in channel add order
         */
        int16_t *getData() { return data; }
    private:
        int16_t data[sizeof(int16_t)*8]; // 8 channels
};
 
 #endif // ACD_NRF52_SAADC_H