/*
================================================================================
Project:    MTU Tracker
Module:     app data
Status:     Development
Type:       .h header file
Copyright (c) 2018 Pathfindr Ltd
All Rights Reserved.
================================================================================
Notes:

================================================================================
*/
#ifndef APP_DATA_H_
#define APP_DATA_H_

//------------------------------------------------------------------------------
//Dependencies
//------------------------------------------------------------------------------
#include "main.h"

//------------------------------------------------------------------------------
//GLOBAL function macros
//------------------------------------------------------------------------------
//NONE
//------------------------------------------------------------------------------
//GLOBAL constants - STATUS BIT FLAG DEFINITIONS
//------------------------------------------------------------------------------
//status flag - bit positions
const uint32_t rollback_flag      = 0x00000001  ; //flag - load from bank 2 to bank 1.
const uint32_t app_execution_flag = 0x00000002  ; //flag - set in bootloader, clear on app ran successfully.
const uint32_t registered_flag    = 0x00000004  ; //flag - set when connected to database and registered board data.
const uint32_t first_run_flag     = 0x00000008  ; //flag - placeholder - how do we detect if the formware is run for  the first time?
const uint32_t sleep_pending      = 0x00000010  ; //flag - on reset check this flag and enter deep sleep if set
const uint32_t get_status_flag    = 0x00000020  ; //flag - on button press set this flag
const uint32_t wakeup_flag        = 0x00000040  ; //flag - on wakeup set this flag
//status led - states
const uint32_t blinky_ok                  = 0x00000001 ;
const uint32_t blinky_update_failed       = 0x00000002 ;
const uint32_t blinky_stuck_in_bootloader = 0x00000003 ;
//------------------------------------------------------------------------------
//GLOBAL data structures - APP DATA
//------------------------------------------------------------------------------
typedef struct{
    uint32_t current_firmware_version;      
    uint32_t target_firmware_version;       // 0 = get latest firmware
    uint32_t app_execution_fail_counter; 
    uint32_t blinky_state;                  // status of led on periodic wake
    uint32_t sleep_counter;                 // tracks the period between update attempts 
    uint32_t sleep_duration;                // 
    uint32_t update_duration;
    uint32_t reset_counter;
    uint32_t wd_counter;
    uint32_t status_flags;                  // status flag register
} app_data_t;    
#define N_SETTINGS 10
//------------------------------------------------------------------------------
//GLOBAL variables
//------------------------------------------------------------------------------
extern app_data_t app_data; 
//------------------------------------------------------------------------------
//GLOBAL function prototypes
//------------------------------------------------------------------------------
//Read/write app data to Flash memory
//extern bool flash_test(app_data_t *ptr);
//extern void print_app_data(app_data_t *ptr);
extern bool write_app_data_to_flash(app_data_t *ptr);
extern bool read_app_data_from_flash(app_data_t *ptr);
extern void clear_app_data(app_data_t *ptr);
extern void set_app_data(app_data_t *ptr);

//Flag operations
extern bool set_flag(app_data_t *ptr, uint32_t flag);
extern bool get_flag(app_data_t *ptr, uint32_t flag);
extern bool clr_flag(app_data_t *ptr, uint32_t flag);
extern bool tgl_flag(app_data_t *ptr, uint32_t flag);
extern bool rst_flag_buffer(app_data_t *ptr);

#endif 



