//------------------------------------------------------------------------------
//This module:
//------------------------------------------------------------------------------
#include "app_data.h"
//------------------------------------------------------------------------------
//LOCAL Macros
FlashIAP flash;
//------------------------------------------------------------------------------
//debugging state
#define DEBUG_THIS DEBUG_APP_DATA
//------------------------------------------------------------------------------
//IO pin setup
//------------------------------------------------------------------------------
//NONE
//------------------------------------------------------------------------------
//GLOBAL Variables
//------------------------------------------------------------------------------
app_data_t app_data; 
//------------------------------------------------------------------------------
//LOCAL Data structures
//------------------------------------------------------------------------------
//NONE
//------------------------------------------------------------------------------
//LOCAL Constants
//------------------------------------------------------------------------------
//NONE
//------------------------------------------------------------------------------
//LOCAL Variables
//------------------------------------------------------------------------------
//NONE
//------------------------------------------------------------------------------
//LOCAL Function prototypes
//------------------------------------------------------------------------------
//NONE
//------------------------------------------------------------------------------
//LOCAL Function definitions
//------------------------------------------------------------------------------
//NONE
//------------------------------------------------------------------------------
//GLOBAL Function definitions
//------------------------------------------------------------------------------
extern bool set_flag(app_data_t *ptr, uint32_t flag)
{
    ptr->status_flags |= flag;
    return 0;    
}
//------------------------------------------------------------------------------
extern bool get_flag(app_data_t *ptr, uint32_t flag)
{
    bool result;
    result = (ptr->status_flags & flag);
    return result;    
}
//------------------------------------------------------------------------------
extern bool clr_flag(app_data_t *ptr, uint32_t flag)
{
    ptr->status_flags &= ~flag;
    return 0;
}
//------------------------------------------------------------------------------
extern bool tgl_flag(app_data_t *ptr, uint32_t flag)
{
    ptr->status_flags ^= flag;
    return 0;  
}
//------------------------------------------------------------------------------
extern bool rst_flag_buffer(app_data_t *ptr)
{
    ptr->status_flags = 0;
    return 0;
}
//------------------------------------------------------------------------------
extern bool write_app_data_to_flash(app_data_t *ptr)
//write the app data to the memory location defined by APPDATA_START
{
    bool pass = false;
    int8_t error = 0;       //used to catch errors in the flash operations
    debug_prep();snprintf(GLOBAL_debug_buffer, sizeof(GLOBAL_debug_buffer), "Flash - Init 1");debug_exe();
    error = flash.init();
    if(error != 0) 
    {
        //DEBUG(DEBUG_THIS, "ERROR: flash init %d \r\n", error);
        debug_prep();snprintf(GLOBAL_debug_buffer, sizeof(GLOBAL_debug_buffer), "ERROR: flash init %d",error);debug_exe();
        return false;
    }
    const uint32_t page_size = flash.get_page_size();
    char page_buffer[page_size];
    uint32_t addr = APPDATA_START;
    uint32_t value[1] = {0};
    uint32_t val = 0;
    uint8_t setting = 1;
    debug_prep();snprintf(GLOBAL_debug_buffer, sizeof(GLOBAL_debug_buffer), "Flash - Init 2");debug_exe();
    flash.init();  
    // DEBUGGING APP DATA MEMORY CRASH
    debug_prep();snprintf(GLOBAL_debug_buffer, sizeof(GLOBAL_debug_buffer), "Flash - Erase");debug_exe();
    error = flash.erase(addr, flash.get_sector_size(addr));
    if(error != 0) 
    {
        //DEBUG(DEBUG_THIS, "ERROR: flash erase %d \r\n", error);
        debug_prep();snprintf(GLOBAL_debug_buffer, sizeof(GLOBAL_debug_buffer), "ERROR: flash erase %d",error);debug_exe();
        return false;
    }  
    
    //DEBUG(DEBUG_THIS, "WRITE VALUES FROM RAM TO FLASH... \r\n\n"); 
    debug_prep();snprintf(GLOBAL_debug_buffer, sizeof(GLOBAL_debug_buffer), "Flash - Write 1");debug_exe();
    for(setting=1; setting<=N_SETTINGS; setting++)
    {
        switch(setting)
        {
            case 1: val = ptr->current_firmware_version;    break;
            case 2: val = ptr->target_firmware_version;     break;
            case 3: val = ptr->app_execution_fail_counter;  break;
            case 4: val = ptr->blinky_state;                break;
            case 5: val = ptr->sleep_counter;               break;
            case 6: val = ptr->sleep_duration;              break;
            case 7: val = ptr->update_duration;             break;
            case 8: val = ptr->reset_counter;               break; 
            case 9: val = ptr->wd_counter;                  break;           
            case 10: val = ptr->status_flags;               break;
            default: 
                //DEBUG(DEBUG_THIS, "Undefined state in function: %s() \r\n", __FUNCTION__); 
                break;
        }   
            
        //DEBUG(DEBUG_THIS, "COPY : %u to BUFFER \r\n", val); 
        //transfer the 32bit uint to the char page buffer
        page_buffer[0] = (char)(val & 0x000000FF); 
        page_buffer[1] = (char)((val & 0x0000FF00) >> 8); 
        page_buffer[2] = (char)((val & 0x00FF0000) >> 16); 
        page_buffer[3] = (char)((val & 0xFF000000) >> 24);            
                
        //transfer the page buffer to the flash memory
        debug_prep();snprintf(GLOBAL_debug_buffer, sizeof(GLOBAL_debug_buffer), "Flash - Write 2");debug_exe();
        error = flash.program(page_buffer, addr, page_size); 
        if(error != 0) 
        {
            //DEBUG(DEBUG_THIS, "ERROR: flash program %d \r\n", error);
            debug_prep();snprintf(GLOBAL_debug_buffer, sizeof(GLOBAL_debug_buffer), "ERROR: flash program %d",error);debug_exe();
            return false;
        }    
        //for debug check read back the value...
        //doesn't need error checking, not essential.
        memset(value, 0x00, 4);
        flash.read(value, addr, 4);    
        //DEBUG(DEBUG_THIS, "READ FROM ADDR: 0x%08x \t VALUE: %u \r\n", addr, value[0]); 
        addr += page_size;
    }

    debug_prep();snprintf(GLOBAL_debug_buffer, sizeof(GLOBAL_debug_buffer), "Flash - Deinit");debug_exe();
    error = flash.deinit();  
    if(error != 0) 
    {
        //DEBUG(DEBUG_THIS, "ERROR: flash deinit %d \r\n", error);
        debug_prep();snprintf(GLOBAL_debug_buffer, sizeof(GLOBAL_debug_buffer), "ERROR: flash deinit %d",error);debug_exe();
        return false;
    }  
    //DEBUG(DEBUG_THIS, "DONE \r\n");      
    debug_prep();snprintf(GLOBAL_debug_buffer, sizeof(GLOBAL_debug_buffer), "Flash - Done");debug_exe();
    return pass; 
}
//------------------------------------------------------------------------------
extern bool read_app_data_from_flash(app_data_t *ptr)
//read the app data from the memory location defined by APPDATA_START
//and restore to APP_DATA
{
    bool pass = false;
    int8_t error = 0;
    error = flash.init();
    if(error != 0) 
    {
        //DEBUG(DEBUG_THIS, "ERROR: flash init %d \r\n", error);
        return false;
    }
    const uint32_t page_size = flash.get_page_size();
    uint32_t addr = APPDATA_START;
    uint32_t value[1] = {0};
    uint8_t setting = 1;   
    
    //DEBUG(DEBUG_THIS, "\r\nLOAD VALUES TO RAM FROM FLASH... \r\n"); 

    for(setting=1; setting<=N_SETTINGS; setting++)
    {
        error = flash.read(value, addr, 4); 
        if(error != 0) 
        {
            //DEBUG(DEBUG_THIS, "ERROR: flash read %d \r\n", error);
            return false;
        }        
        switch(setting)
        {
            case 1: ptr->current_firmware_version   = value[0]; break;
            case 2: ptr->target_firmware_version    = value[0]; break;
            case 3: ptr->app_execution_fail_counter = value[0]; break;
            case 4: ptr->blinky_state               = value[0]; break;
            case 5: ptr->sleep_counter              = value[0]; break;
            case 6: ptr->sleep_duration             = value[0]; break;
            case 7: ptr->update_duration            = value[0]; break;            
            case 8: ptr->reset_counter              = value[0]; break;  
            case 9: ptr->wd_counter                 = value[0]; break;      
            case 10: ptr->status_flags              = value[0]; break;        
            default: 
                //DEBUG(DEBUG_THIS, "Undefined state in function: %s() \r\n", __FUNCTION__); 
                break;
        }   
        //DEBUG(DEBUG_THIS, "READ FROM ADDR: 0x%08x \t VALUE: %u \r\n", addr, value[0]);           
        addr += page_size; 
    }

    error = flash.deinit();  
    if(error != 0) 
    {
        //DEBUG(DEBUG_THIS, "ERROR: flash deinit %d \r\n", error);
        return false;
    }    
    //DEBUG(DEBUG_THIS, "DONE \r\n");  
    return pass; 
}
//------------------------------------------------------------------------------
extern void clear_app_data(app_data_t *ptr)
//reset the app data values
{
    ptr->current_firmware_version   = 0;
    ptr->target_firmware_version    = 0;
    ptr->app_execution_fail_counter = 0;
    ptr->blinky_state               = 0;     
    ptr->sleep_counter              = 0;              
    ptr->sleep_duration             = 0;
    ptr->update_duration            = 0;  
    ptr->reset_counter              = 0;
    ptr->wd_counter                 = 0;
    ptr->status_flags               = 0;    
    return;   
}
//------------------------------------------------------------------------------
extern void set_app_data(app_data_t *ptr)
//test function - load some initial values for testing
{
    ptr->current_firmware_version   = 0xFFFF0000;
    ptr->target_firmware_version    = 0x0000FFFF;
    ptr->app_execution_fail_counter = 0x00FFFF00;
    //set flags in one go...
    ptr->status_flags               = 0xAAAAAAAA;             //flag - load from bank 2 to bank 1.
    //...or one at a time
    set_flag(ptr, rollback_flag);
    clr_flag(ptr, app_execution_flag);
    tgl_flag(ptr, registered_flag);   
    set_flag(ptr, first_run_flag);
    return;   
}
//------------------------------------------------------------------------------
