#include "NRFuart.h"

void NRFuart_init_nohwfc() {
    if(NRF_UART0->ENABLE == UART_ENABLE_ENABLE_Disabled) {
        nrf_gpio_cfg_output(PN_UART_TX);
        nrf_gpio_cfg_input(PN_UART_RX, NRF_GPIO_PIN_NOPULL);
        NRF_UART0->PSELTXD = PN_UART_TX;
        NRF_UART0->PSELRXD = PN_UART_RX;
        NRF_UART0->CONFIG = (UART_CONFIG_PARITY_Excluded << UART_CONFIG_PARITY_Pos) | UART_CONFIG_HWFC_Disabled;
        NRF_UART0->BAUDRATE = NRF_UART_BAUDRATE_115200;
        NRF_UART0->ENABLE = UART_ENABLE_ENABLE_Enabled;
        NRF_UART0->EVENTS_RXDRDY = 0;
        NRF_UART0->EVENTS_TXDRDY = 0;
        NRF_UART0->EVENTS_ERROR  = 0;
        NRF_UART0->EVENTS_TXDRDY = 0;
        NRF_UART0->TASKS_STARTRX = 1;
        NRF_UART0->TASKS_STARTTX = 1;
        //NRF_UART0->INTENCLR = 0xffffffffUL;
        //NRF_UART0->INTENSET = UART_INTENSET_RXDRDY_Msk; //or
        //NRF_UART0->INTENSET = (UART_INTENSET_RXDRDY_Set << UART_INTENSET_RXDRDY_Pos) |
        //                      (UART_INTENSET_TXDRDY_Set << UART_INTENSET_TXDRDY_Pos) |
        //                      (UART_INTENSET_ERROR_Set << UART_INTENSET_ERROR_Pos); 
        //NVIC_ClearPendingIRQ(UART0_IRQn);
        //NVIC_SetPriority(UART0_IRQn, 1); //3
        //NVIC_EnableIRQ(UART0_IRQn);
        //NVIC_SetVector(UART0_IRQn, (uint32_t) UART0_IRQHandler);
    }
};
void NRFuart_init_hwfc() {
    if(NRF_UART0->ENABLE == UART_ENABLE_ENABLE_Disabled) {
        nrf_gpio_cfg_output(PN_UART_TX);
        nrf_gpio_cfg_input(PN_UART_RX, NRF_GPIO_PIN_NOPULL);
        NRF_UART0->PSELTXD = PN_UART_TX;
        NRF_UART0->PSELRXD = PN_UART_RX;
        NRF_UART0->PSELCTS = PN_UART_CTS;
        NRF_UART0->PSELRTS = PN_UART_RTS;
        NRF_UART0->CONFIG = (UART_CONFIG_PARITY_Excluded << UART_CONFIG_PARITY_Pos) | UART_CONFIG_HWFC_Enabled;
        NRF_UART0->BAUDRATE = NRF_UART_BAUDRATE_115200;
        NRF_UART0->ENABLE = UART_ENABLE_ENABLE_Enabled;
        NRF_UART0->EVENTS_RXDRDY = 0;
        NRF_UART0->EVENTS_TXDRDY = 0;
        NRF_UART0->EVENTS_ERROR  = 0;
        NRF_UART0->EVENTS_TXDRDY = 0;
        NRF_UART0->TASKS_STARTRX = 1;
        NRF_UART0->TASKS_STARTTX = 1;
        //NRF_UART0->INTENCLR = 0xffffffffUL;
        //NRF_UART0->INTENSET = UART_INTENSET_RXDRDY_Msk; //or
        //NRF_UART0->INTENSET = (UART_INTENSET_RXDRDY_Set << UART_INTENSET_RXDRDY_Pos) |
        //                      (UART_INTENSET_TXDRDY_Set << UART_INTENSET_TXDRDY_Pos) |
        //                      (UART_INTENSET_ERROR_Set << UART_INTENSET_ERROR_Pos);   
        //NVIC_ClearPendingIRQ(UART0_IRQn);
        //NVIC_SetPriority(UART0_IRQn, 1); //3
        //NVIC_EnableIRQ(UART0_IRQn);
        //NVIC_SetVector(UART0_IRQn, (uint32_t) UART0_IRQHandler);
    }
};
void NRFuart_uninit() {
    if (NRF_UART0->ENABLE == UART_ENABLE_ENABLE_Enabled) {
        NVIC_DisableIRQ(UART0_IRQn);
        NRF_UART0->INTENCLR = 0xffffffffUL;
        NRF_UART0->TASKS_STOPRX = 1;
        NRF_UART0->TASKS_STOPTX = 1;
        NRF_UART0->ENABLE = UART_ENABLE_ENABLE_Disabled;
        NRF_UART0->PSELTXD = 0xFFFFFFFF;
        NRF_UART0->PSELRXD = 0xFFFFFFFF;
        NRF_UART0->PSELRTS = 0xFFFFFFFF;
        NRF_UART0->PSELCTS = 0xFFFFFFFF;
    }
};
void NRFuart_putc(char byte) {
    if (!NRF_UART0->ENABLE) NRFuart_init_nohwfc();
    NRF_UART0->TXD = byte;
    uint32_t safetycounter = 0;
    while(NRF_UART0->EVENTS_TXDRDY != 1 && safetycounter < 10000) {
        safetycounter ++; // Wait for the current TXD data to be sent.
    }
    NRF_UART0->EVENTS_TXDRDY = 0;
};
void NRFuart_puts(char* bytes) {
    if (!NRF_UART0->ENABLE) NRFuart_init_nohwfc();
    uint32_t safetycounter = 0;
    for(int i = 0; bytes[i] != 0x00; i++) {
        NRFuart_putc(bytes[i]);
        safetycounter ++;
        if (safetycounter > 10000) break;   
    }
};
void NRFuart_puts_debug(char* bytes) {
    if (!NRF_UART0->ENABLE) NRFuart_init_nohwfc();
    uint32_t safetycounter = 0;
    for(int i = 0; bytes[i] != 0x00; i++) {
        NRFuart_putc(bytes[i]);
        safetycounter ++;
        if (safetycounter > 10000) break; 
    }
    NRFuart_putc('\n');
};
void debug_prep(){
    memset(GLOBAL_debug_buffer, 0x00, sizeof(GLOBAL_debug_buffer));   
}
void debug_exe(){
    NRFuart_puts_debug(GLOBAL_debug_buffer);
}
char NRFuart_getc() {
    if (!NRF_UART0->ENABLE) NRFuart_init_nohwfc();
    uint32_t safetycounter = 0;
    while(NRF_UART0->EVENTS_RXDRDY != 1 && safetycounter < 10000){
        safetycounter ++;
    }
    NRF_UART0->EVENTS_RXDRDY = 0;
    return (uint8_t)NRF_UART0->RXD;
};
char* NRFuart_gets(char terminator) {
    if (!NRF_UART0->ENABLE) NRFuart_init_nohwfc();
    static char buffer[200];
    int charindex = 0;
    memset(buffer,0x00,sizeof(buffer));
    uint32_t safetycounter = 0;
    while(1 && safetycounter < 10000) {
        if (NRF_UART0->EVENTS_RXDRDY == 0) {
            safetycounter ++;
            //Nothing available from the UART.
            continue;
        } else {
            char inbyte = NRFuart_getc();
            if (inbyte == terminator) {
                break;
            } else {
                buffer[charindex] = inbyte;
                charindex++;
            }
        }
    }
    buffer[charindex] = '\n'; //make sure we end with whitespace lf
    return buffer;
};
void NRFuart_flush() {
    if (!NRF_UART0->ENABLE) NRFuart_init_nohwfc();
    uint32_t safetycounter = 0;
    while (NRFuart_readable() && safetycounter < 10000) {
        safetycounter ++;
        char char1 = NRFuart_getc();
    }
};
bool NRFuart_readable() {
    if (!NRF_UART0->ENABLE) NRFuart_init_nohwfc();
    return (NRF_UART0->EVENTS_RXDRDY == 1);
};