#ifndef MM2WAYRANGING_H
#define MM2WAYRANGING_H
 
#include "mbed.h"
#include "DW1000.h"


#define TIMEUNITS_TO_US       (1/(128*499.2))               // conversion between the decawave timeunits (ca 15.65ps) to microseconds.
#define US_TO_TIMEUNITS       (128*499.2)                   // conversion between microseconds to the decawave timeunits (ca 15.65ps).
#define MMRANGING_2POWER40    1099511627776                 // decimal value of 2^40 to correct timeroverflow between timestamps
 
//Predefined delay for the critical answers in the ranging algorithm
//HAS TO BE BIGGER THAN THE PROCESSING TIME OF THE FRAME ON THE NODE
#define ANSWER_DELAY_US             2500                                    //2500 works for 110kbps, 900 for 6.8Mbps
#define ANSWER_DELAY_TIMEUNITS      ANSWER_DELAY_US * (128*499.2)

class MM2WayRanging {
 
public:
    MM2WayRanging(DW1000& DW);
 
    bool beacon_requestRanging();
    void anchor_standbyToRange();
 
    bool isBeacon;
    uint8_t address;                // Identifies the nodes as source and destination in rangingframes
    bool overflow;                  // TRUE if counter overflows while ranging
 
private:
    DW1000& dw;
    Timer LocalTimer;
 
    bool waitForFrameTX(float time_before);
    bool waitForFrameRX(float time_before);
    void callbackRX();
    void callbackTX();
    
    void beacon_ready_Send();
    void anchor_to_beacon_Send(uint8_t destination);
    void beacon_to_anchor_response_Send(uint8_t destination, uint64_t rxTimestamp);
 
    //void correctReceiverTimestamps(uint8_t source);
    //void correctSenderTimestamps(uint8_t source);
 
    enum FrameType{
        BEACON_READY=1,
        ANCHOR_TO_BEACON_PING,
        BEACON_TO_ANCHOR_RESPONSE
    };
 
    //the packed attribute makes sure the types only use their respective size in memory (8 bit for uint8_t), otherwise they would always use 32 bit
    //IT IS A GCC SPECIFIC DIRECTIVE
    struct __attribute__((packed, aligned(1))) RangingFrame {
        uint8_t source;
        uint8_t destination;
        uint8_t type;
    };
 
    RangingFrame rangingFrame;                  // buffer in class for sending a frame (not made locally because then we can recall in the interrupt what was sent)
    RangingFrame receivedFrame;
    
    uint64_t RxTimestamp;
    uint64_t rangingTxTimestamp[5];
    uint64_t rangingRxTimestamp[5];
    uint64_t rangingTOF[5];
    float rangingDistance[5];
};
#endif