#include "mbed.h"
#include "rtos.h"
#include "TextLCD.h"
#include <stdio.h>
#include <stdlib.h>

#define RUN 0x1

TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD16x2);
Serial pc (USBTX, USBRX);

// ports
DigitalIn VGet(p11);
DigitalIn AGet(p12);
DigitalOut VPace(p13);
DigitalOut APace(p14);
PwmOut speaker(p21);

// LEDs
DigitalOut leds[] = {LED1, LED2, LED3, LED4};
// 1 = VP
// 2 = AP
// 3 = VS
// 4 = AS

// input stuff
char input;

// heart rate global vars
int HR = 0;
int beats = 0;
int sampleRate = 10000; // default 10 seconds
int firstSample = 1;
int Omode = 0;

// Normal Values
const int N_PVARP = 325;    // ms
const int N_VRP   = 300;    // ms
const int N_LRI   = 857;    // ms (= about 70ppm)
const int N_AVI   = 65;     // ms
const int N_UB    = 100;    // 100ppm
const int N_LB    = 40;     // 40ppm

// Exercise Values
const int E_PVARP = 175;    // ms
const int E_VRP   = 150;    // ms
const int E_LRI   = 428;    // ms (= about 140ppm)
const int E_AVI   = 30;     // ms
const int E_UB    = 175;    // 175ppm
const int E_LB    = 100;    // 100ppm

// Sleep Values
const int S_PVARP = 500;    // ms
const int S_VRP   = 475;    // ms
const int S_LRI   = 1333;   // ms (= about 45ppm)
const int S_AVI   = 100;    // ms
const int S_UB    = 60;     // 60ppm
const int S_LB    = 30;     // 30ppm

// Heart Values - Normal Mode is default
int PVARP = N_PVARP;
int VRP = N_VRP;
int LRI = N_LRI;
int AVI = N_AVI;
int UB = N_UB;
int LB = N_LB;

// status flags
int isVRP = 0;
int isPVARP = 0;
int inManual = 0;

