#include "uStep.h"
#include "mbed.h"

uStep::uStep(PinName FAZ1, PinName FAZ2, PinName FAZ3, PinName FAZ4) : _FAZ1(FAZ1), _FAZ2(FAZ2), _FAZ3(FAZ3), _FAZ4(FAZ4)   //DEFINICIJA PINOVA MOTORA
{
    i = 0;
    trenutniKorak = 0;
    maxKoraci = 0;
    busy = false;
    _FAZ1=0;
    _FAZ2=0;
    _FAZ3=0;
    _FAZ4=0;
}
void uStep::step1()
{
    _FAZ1=0;
    _FAZ2=0;
    _FAZ3=0;
    _FAZ4=1;
}
void uStep::step2()
{
    _FAZ1=0;
    _FAZ2=0;
    _FAZ3=1;
    _FAZ4=1;
}
void uStep::step3()
{
    _FAZ1=0;
    _FAZ2=0;
    _FAZ3=1;
    _FAZ4=0;
}
void uStep::step4()
{
    _FAZ1=0;
    _FAZ2=1;
    _FAZ3=1;
    _FAZ4=0;
}
void uStep::step5()
{
    _FAZ1=0;
    _FAZ2=1;
    _FAZ3=0;
    _FAZ4=0;
}
void uStep::step6()
{
    _FAZ1=1;
    _FAZ2=1;
    _FAZ3=0;
    _FAZ4=0;
}
void uStep::step7()
{
    _FAZ1=1;
    _FAZ2=0;
    _FAZ3=0;
    _FAZ4=0;
}
void uStep::step8()
{
    _FAZ1=1;
    _FAZ2=0;
    _FAZ3=0;
    _FAZ4=1;
}

void uStep::motorStop()
{
    _FAZ1=0;
    _FAZ2=0;
    _FAZ3=0;
    _FAZ4=0;
}

void uStep::ooskz()   // ROTIRAJ MOTOR U SMJERU OBRNUTOM D KAZALJKE NA SATU
{
    switch(i) {
        case 0: step1(); break;
        case 1: step2(); break;
        case 2: step3(); break;
        case 3: step4(); break;
        case 4: step5(); break;
        case 5: step6(); break;
        case 6: step7(); break;
        case 7: step8(); break;
    }
    zbrojiZaJedan();
}

void uStep::skz()   // ROTIRAJ MOTOR JEDNOM U SMJERU KAZALJKE NA SATU
{
    switch(i) {
        case 0: step8(); break;
        case 1: step7(); break;
        case 2: step6(); break;
        case 3: step5(); break;
        case 4: step4(); break;
        case 5: step3(); break;
        case 6: step2(); break;
        case 7: step1(); break;
    }
    zbrojiZaJedan();
}
void uStep::zbrojiZaJedan()
{
    if (i < 7)
        i++;
    else {
        i = 0;
        trenutniKorak++;
    }
        
    if (trenutniKorak >= maxKoraci)
    {
        steptick.detach();
        motorStop();
        trenutniKorak = 0;
        busy = false;
    }
}

void uStep::step(int koraci, int smjer, float brzina)  // FUNKCIJA STEP MOTORA (BROJ KORAKA, SMJER VRTNJE, BRZINA VRTNJE)
{
    motorStop();
    i = 0;
    trenutniKorak = 0;
    busy = true;
    maxKoraci = koraci;
    motorbrzina = brzina; //POSTAVLJANJE BRZINE MOTORA
    if (smjer == 0) // OKRETANJE U SMJERU KAZALJKE NA SATU
    {
        steptick.attach(this, &uStep::skz, motorbrzina);
        skz();
    }
    else if (smjer==1)// OKRETANJE OBRNUTO OD KAZALJKE NA SATU
    {
        steptick.attach(this, &uStep::ooskz, motorbrzina);
        ooskz();
    }

}

bool uStep::isRunning()
{
    return busy;
}