#ifndef PROJEKT_H
#define PROJEKT_H

#include "mbed.h"

/** A simple class for lighting control on the road using
 * a 4 led diodes, one analog photocell sensor and 3 IR sensor.
 *
 * Author(s): Krešimir Filipec
 *
 */

class Projekt {
           public:
           /** Constructor receives pin names of the IR sensor and
         * the AnalogIn pin to which the photocell is connected. */
           Projekt(PinName startPin, PinName start1Pin, PinName stopPin, PinName senzorPin);
           private:
           InterruptIn start, start1, stop;
           AnalogIn senzor;
           Timer time;
           Timeout time1;
           DigitalOut led1, led2, led3, led4;
           void ukljuci();
           void iskljuci();
           bool ukljuceno;
           void ukljuci1();
           void ugasi();
           /** Read the current light from the sensor. */
           float x;
};
#endif 