#include "mbed.h"
#include "time.h"

 
Serial pc(USBTX, USBRX); // tx, rx
PwmOut myled(LED1);

PwmOut pwmNO(D9);
DigitalOut dirNO(D7);
PwmOut pwmNE(D10);
DigitalOut dirNE(D8);


float speedLeft = 0.0;
float speedRight = 0.0;
 
int main() {
    srand (time (NULL));
    myled=1;wait(.2);
    myled=0;wait(.2);
    myled=1;wait(.2);
    myled=0;wait(.2);
    myled=1;wait(.2);
 
    pc.printf("Hello!\n");
    
    pwmNO.period_us(1000);
    pwmNE.period_us(1000);
    dirNO=0;
    dirNE=1;
    
    pwmNO.pulsewidth_us(0);
    pwmNE.pulsewidth_us(0);
    
    speedLeft = 0.4;
    speedRight = 0.4;
    wait(1);
    int i;
    for(i=0;i<10;i++)
    {
        int avanceGauche;
        int avanceDroit;
        avanceGauche=rand()%3;
        avanceDroit=rand()%3;
        if ((avanceGauche==0) && (speedLeft > -0.8))
        {
            speedLeft -= 0.2;
        } else {
        if ((avanceGauche==2) && (speedLeft < 0.8))
        {
            speedLeft += 0.2;
        }
        }
        if ((avanceDroit==0) && (speedRight > -0.8))
        {
            speedRight -= 0.2;
        } else {
        if ((avanceDroit==2) && (speedRight < 0.8))
        {
             speedRight += 0.2;
        }
        }
        
        if(speedLeft>0){
            dirNO=0;
            pwmNO.pulsewidth_us(1000*speedLeft);
        } else {
            dirNO=1;
            pwmNO.pulsewidth_us(-1000*speedLeft);
        }
        if(speedRight>0){
            dirNE=1;
            pwmNE.pulsewidth_us(1000*speedRight);
        } else {
            dirNE=0;
            pwmNE.pulsewidth_us(-1000*speedRight);
        }
        wait(0.4);
    }
        
    speedLeft = 0.0;
    speedRight = 0.0;
    if(speedLeft>0){
        dirNO=0;
        pwmNO.pulsewidth_us(1000*speedLeft);
    } else {
        dirNO=1;
        pwmNO.pulsewidth_us(-1000*speedLeft);
    }
    if(speedRight>0){
        dirNE=1;
        pwmNE.pulsewidth_us(1000*speedRight);
    } else {
        dirNE=0;
        pwmNE.pulsewidth_us(-1000*speedRight);
    }
}
