#include "mbed.h"
#include "CAN3.h"
#include "mcp2515.h"
#include <string>
#include <sstream>
#include <algorithm>
#define DIM_STORE 6000
#define DIM_PARAMS 10
using namespace std;

RawSerial pc(USBTX,USBRX);
DigitalOut myled(LED2);
SPI spi(SPI_MOSI,SPI_MISO,SPI_SCK);
CAN3 can(spi,SPI_CS,PA_1);


CANMessage msg1;

char data='A';
char vrx[1000]; //memorizzo i caratteri ricevuti dopo il comando di start '+'

bool start=false;   // true quando ho ricevuto il comando di start '+'
bool stop=false;    // true quando ho ricevuto il comando di stop '-'

bool canread=false; //true per abilitare la lettura da can

int i = 0;
int j = 0;
int k = 0;
int index_data;
int i_row = 0;
const char* FromStrToChar;
size_t n,pos;
string delimiter = ",";
string paramlist[DIM_PARAMS];
string StoreData[DIM_STORE]; 

void clear_StoreData(){
    int it;
    for(it = 0; it < DIM_STORE; it++)
        StoreData[it].clear();    
}

void clear_paramlist(){
    int it;
    for(it = 0; it < DIM_PARAMS; it++)
        paramlist[it].clear();    
}

void rxCallback(){
    data = char(pc.getc());
    if (data == '+'){
            myled = 1;
            i=0;
            j=0;
            start=true;
            clear_paramlist();
            clear_StoreData();
    }else if(data == '-'){
            myled=0;
            stop=true;
            start=false;
            canread=false; //disabilito la lettura da CAN
            //pc.puts("123?");
        }else{
            if(start){
                //quando ricevo il terminatore del messaggio '?'
                if(data == '?'){//quando ricevo il terminatore del messaggio '?'
                        
                        //converto il vettore di char in string
                        string strrx(vrx); 
                        //contro il numero di id che sono stati ricevuti contando le ','
                        n = count(strrx.begin(),strrx.end(),',');
                                               
                        pos = 0;
                        
                        //faccio il parsing della stringa, salvando i diversi Id ricevuti in un vettore di stringhe
                        while((pos = strrx.find(',')) != string::npos){
                                paramlist[i_row] = strrx.substr(0,pos);
                                strrx.erase(0,pos+1);
                                i_row++;         
                          }
                          canread=true; //abilito la lettura da CAN
                          index_data = 0;
                    }else { //altrimenti memorizzo il carattere ricevuto
                            vrx[i]=data;
                            i++;
                        }
                
                
                }
            
            
            
            
            }
}

int main() {
    int index;
    can.frequency(125000);
    pc.attach(&rxCallback, RawSerial::RxIrq);
    while(true){
        if(canread){
            //ToDo: devo leggere da CAN
            if(can.read(&msg1)){
                for(index = 0; index < i_row-1; index++){
                    if(msg1.id == atoi(paramlist[index].c_str())){
                         string tmpData = string(msg1.data, find(msg1.data, msg1.data + 8, '\0'));
                         stringstream ss;
                         ss << msg1.id;
                         StoreData[index_data] = ss.str()+","+tmpData;
                         index_data++;                                          
                    }
            }
            }else if (stop){
                //ToDo: devo mandare tutto quello che ho letto sulla seriale
                //pc.puts("101,20|101,20|101,20|101,20|101,20|259,1|101,20|101,20|101,20|101,20|101,20|259,3.0?");
                for(int z = 0; z < index_data-2; z++){
                    pc.puts(StoreData[z].c_str()+'|');
                    //pc.putc('|');       
                }
                pc.puts(StoreData[index_data-1].c_str()+'?');
                
                stop=false;
                start=false;
                canread=false;
                }
            
        }
    }
}
