/*
RobotCup ENS Paris Saclay 2020-2021
Team FC Furious
Code by Luc DERRIEN adapted by Eve

Programme communication PC-Robot
Point de vue : PC
micro controleur : L475

envoi d'une chaine de caractère de taille TRANSFER_SIZE
*/

#include "mbed.h"
#include "string.h"
#include "nRF24L01P.h"
#include "float.h"
#include "MX12.h"
#include "stdio.h"

BufferedSerial pc_serie(USBTX,USBRX,115200);

nRF24L01P my_nrf24l01p(D11, D12, D13, D9, D2, D1);    // mosi, miso, sck, csn, ce, irq
DigitalOut maled2(LED2);


int main()
{

#define TRANSFER_SIZE   12

    char chaine[50];
    char tampon;
    
    char* reception8;
    int16_t reception16[TRANSFER_SIZE/2];
    reception8 = (char*) reception16;
    int16_t Vavance, Vlat,Wz;
    int i;
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2420);
    my_nrf24l01p.setAirDataRate(1000);
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.setCrcWidth(0);
    my_nrf24l01p.setRxAddress();
    my_nrf24l01p.enable();
    

    pc_serie.write("Je suis le robot de Eve", strlen("Je suis le robot de Eve"));

    maled2 = 1;
    MX12 servo_bus(PC_4, PC_5, 115200);

    while (1) {


        if (my_nrf24l01p.readable()) {
            maled2 = !maled2;
            my_nrf24l01p.read( NRF24L01P_PIPE_P0, reception8, TRANSFER_SIZE );
            for (i=0 ; i<TRANSFER_SIZE;i+=2){
                tampon = reception8[i+1];
                reception8[i+1] = reception8 [i];
                reception8[i]= tampon;
                }
                
            Vavance = reception16[0];
            Vlat = reception16[1];
            Wz = reception16[2];
            
            sprintf(chaine," Vav = %d, Vlat = %d, Wz = %d\n\r",(int)Vavance, (int)Vlat, (int)Wz);
            pc_serie.write(chaine, strlen(chaine));
        servo_bus.cmd_moteur(Vavance/1000.0,  Vlat/1000.0, Wz);

        }

    }

}

