#include "mbed.h"
#include "string.h"
#include "nRF24L01P.h"
#include "string.h"
#include "MX12.h"
#include "DRIBBLE.h"

DigitalOut charge (D0);
DigitalOut kick (D3);
DigitalOut myled(LED2);
Thread thread;
Thread thread2;
dribbleur d(D15);
BufferedSerial pc_serie(USBTX,USBRX,115200);
MX12 bus(PC_4,PC_5,115200);
nRF24L01P my_nrf24l01p(D11, D12, D13, D9, D2, D1);    // mosi, miso, sck, csn, ce, irq
int8_t instructionDribble=0;
int instructionPowerOff;
int instructionTir = 0;

void dribbleOn()
{
    int instructionDribble_old = 0;
    int i;
    while(1) {
        if((instructionDribble == 1) && (instructionDribble_old ==0)) {
            for (i=10; i<=40; i=i+1) {
                d.SetSpeed(i);
                thread_sleep_for(100);
            }
        }
        if(instructionDribble == 0) {
            d.SetSpeed(0);
        }

        instructionDribble_old = instructionDribble;
        thread_sleep_for(10);
    }
}



int main()
{
    myled = 1 ;

#define TRANSFER_SIZE 12

    int16_t Vavance_mm_s;
    int16_t Vlat_mm_s;
    int16_t Vrot_mrad_s;

    char tab[TRANSFER_SIZE];
    int i;
    char text[50];

    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2422);
    my_nrf24l01p.setAirDataRate(1000);
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.setCrcWidth(0);
    my_nrf24l01p.setRxAddress();
    my_nrf24l01p.enable();
    while (1) {
        if (my_nrf24l01p.readable()) {
            myled = !myled;
            my_nrf24l01p.read( NRF24L01P_PIPE_P0, tab, TRANSFER_SIZE );

//
            //sprintf(text, "trame_recue :");
            //pc_serie.write(text,strlen(text));
            //for(i=0;i<TRANSFER_SIZE;i++)
            //{
            //    sprintf(text, "%x ",tab[i]);
            //    pc_serie.write(text,strlen(text));
            //}
            thread.start(dribbleOn);
            Vavance_mm_s = ((uint16_t)tab[0] << 8) + tab[1];
            Vlat_mm_s = ((uint16_t)tab[2] << 8) + tab[3];
            Vrot_mrad_s = ((uint16_t)tab[4] << 8) + tab[5];
            instructionDribble = tab[6];
            instructionPowerOff = tab[7];
            instructionTir = tab[8];
            if (instructionPowerOff == 12) {
                bus.eteindre_moteurs();
            } else {
                bus.cmd_moteur(-Vavance_mm_s/1000.0,-Vlat_mm_s/1000.0,-Vrot_mrad_s/1000.0);
            }
            if (instructionTir == 1) {
                charge = 1;
                thread_sleep_for(40);
                charge = 0;
            } else if (instructionTir == 2){
                kick = 1;
                thread_sleep_for(10);
                kick = 0;
                }


        }

    }

}
