/*
RobotCup ENS Paris Saclay 2021-2022
Code by Eve Delegue
2021-12-17

Programme communication PC-Robot
Point de vue : pc
micro controleur : L432

envoi d'une chaine de caractère de taille TRANSFER_SIZE = 20
*/

#include "mbed.h"
#include "nRF24L01P.h"

/* 115200 bit/s */
BufferedSerial pc(USBTX, USBRX,115200); // tx, rx

//Définition des E/S de la liaison SPI vers le module nRF24L01+
nRF24L01P my_nrf24l01p(D11, D12, D13, A3, D9, A0);    // mosi, miso, sck, csn, ce, irq


int main()
{

#define TRANSFER_SIZE 12

    char c[50];


    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2406);
    my_nrf24l01p.setAirDataRate(1000);
    my_nrf24l01p.setRfOutputPower(-6);
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setTransmitMode();
    my_nrf24l01p.setCrcWidth(0);
    my_nrf24l01p.setTxAddress();
    my_nrf24l01p.enable();
    DigitalOut led1(D4);
    DigitalOut led2(D5);

    while (1) {
        for (int i=0; i< TRANSFER_SIZE ; i++) {
            while(!pc.readable());
            led1 = !led1;
            pc.read(c+i,1);
        }
        led2 = !led2;
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, c,TRANSFER_SIZE);
        //pc.write(c,TRANSFER_SIZE);
    }
}



