/**
 * @file MX12.ccp
 * @brief This file contains all the methods of the MX12 class
 *        whose prototypes are in the MX12.h header file
 */

#include "DRIBBLE.h"
#include "math.h"

dribbleur::dribbleur(PinName tx)
    : _moteurDribble(tx)    // initializes UnbufferedSerial object
{
    _moteurDribble.pulsewidth_us(0);
    _moteurDribble.period_us(100);
};

void dribbleur::SetSpeed(int pourcentage)
{
    _moteurDribble.pulsewidth_us(pourcentage);
};

void dribbleur::test()
{
    SetSpeed(10);
};

void dribbleur::SetSpeedSmooth()
{
    
};