/*
RobotCup ENS Paris Saclay 2020-2021
Team FC Furious
Code by Luc DERRIEN

Programme communication PC-Robot
Point de vue : pc
micro controleur : L432

envoi d'une chaine de caractère de taille TRANSFER_SIZE = 20
*/

#include "mbed.h"
#include "nRF24L01P.h"

Serial pc(USBTX, USBRX); // tx, rx

//Définition des E/S de la liaison SPI vers le module nRF24L01+
nRF24L01P my_nrf24l01p(D11, D12, D13, A3, D9, A0);    // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(D4);
DigitalOut myled2(D5);

int main()
{

// Nombre de caractères transmis à chaque envoi
#define TRANSFER_SIZE 20

    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    char caractere_recu=0;
    int txDataCnt = 0;
    int rxDataCnt = 0;
    int id_robot, v_tangent, v_normale, omega_robot, spiner_bool, v_tir ;
    int consigneData[6];

    pc.baud(115200); // Débit de la liaison série PC
    pc.printf("Emetteur nRF connecte \n\r");

    my_nrf24l01p.powerUp();

    // paramétrage
    my_nrf24l01p.setRfFrequency(2404); // Définition de la fréquence du canal d'E/R
    my_nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_1_MBPS); // Définition du débit de la communication RF
    my_nrf24l01p.setRfOutputPower(-6);


    // Affichage de l'état de la configuration du nRF24L01+
    pc.printf( "_______________________\r\nCarte coach pc :\r\n_______________________\r\n" );
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );


    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();

    while (1) {

        // If we've received anything over the host serial link...
        if ( pc.readable() ) {
            caractere_recu= pc.getc();
            if (caractere_recu == 'D') {
                txDataCnt = 0;
                myled2 = !myled2;
            } else {
                // ...add it to the transmit buffer
                txData[txDataCnt++] = caractere_recu;
            }
            // If the transmit buffer is full
            if ( txDataCnt >= sizeof( txData ) ) {

                // Send the transmitbuffer via the nRF24L01+
                my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
                pc.printf("donnees envoyees \n\r");
                txDataCnt = 0;
                myled1 = !myled1;
            }
        }
    }
}
