#ifndef _FEEDBACK_HPP_
#define _FEEDBACK_HPP_

#include "mbed.h"
#include "rtos.h"

//Libraries and header file includes


class FEEDBACK
{
    public://Public member functions and variables
    
    FEEDBACK(PinName N1, PinName N2, PinName N3, PinName N4, PinName N5, PinName N6, PinName N7, PinName N8, PinName N9, PinName N10);
    ~FEEDBACK();
    void Init();
    int Post();
    //Public Functions
    
    
    //Getters
    float Get_Battery_Measurement_Value();//Return the batter measurement value
    float Get_Temp_1_Value();//Return the temperature value 1
    float Get_Temp_2_Value();//Return the temperature value 2
    float Get_Temp_3_Value();//Return the temperature value 3
    float Get_Feedback_1_Value();//Return the feedback value 1
    float Get_Feedback_2_Value();//Return the feedback value 2
    float Get_Feedback_3_Value();//Return the feedback value 3
    float Get_Feedback_4_Value();//Return the feedback value 4
    float Get_Feedback_5_Value();//Return the feedback value 5
    float Get_Feedback_6_Value();//Return the feedback value 6
    
    
    private://Private member functions and variables
    
    //Private Functions
    
    //Private GPIO connections
    //Measurement These set the values
    AnalogIn _Battery_Measurement;
    AnalogIn _Temperature_Sensor_1;
    AnalogIn _Temperature_Sensor_2;
    AnalogIn _Temperature_Sensor_3;
    AnalogIn _Feedback_Sensor_1;
    AnalogIn _Feedback_Sensor_2;
    AnalogIn _Feedback_Sensor_3;
    AnalogIn _Feedback_Sensor_4;
    AnalogIn _Feedback_Sensor_5;
    AnalogIn _Feedback_Sensor_6;
    //Private member variables
    
    float _Battery_Measurement_Value;//Value of the battery measurement circuit
    float _Temp_1_Value;    //Temperature sensor feedback 1
    float _Temp_2_Value;    //Temperature sensor feedback 2
    float _Temp_3_Value;    //Temperature sensor feedback 3
    float _Feedback_1_Value;//Feedback sensor 1
    float _Feedback_2_Value;//Feedback sensor 2
    float _Feedback_3_Value;//Feedback sensor 3
    float _Feedback_4_Value;//Feedback sensor 4
    float _Feedback_5_Value;//Feedback sensor 5
    float _Feedback_6_Value;//Feedback sensor 6
    
    //Mutex Locks
    Mutex _Battery_Measurement_Value_Mutex;//Value of the battery measurement circuit mutex lock
    Mutex _Temp_1_Value_Mutex;    //Temperature sensor feedback 1 mutex lock
    Mutex _Temp_2_Value_Mutex;    //Temperature sensor feedback 2 mutex lock
    Mutex _Temp_3_Value_Mutex;    //Temperature sensor feedback 3 mutex lock
    Mutex _Feedback_1_Value_Mutex;//Feedback sensor 1 mutex lock
    Mutex _Feedback_2_Value_Mutex;//Feedback sensor 2 mutex lock
    Mutex _Feedback_3_Value_Mutex;//Feedback sensor 3 mutex lock
    Mutex _Feedback_4_Value_Mutex;//Feedback sensor 4 mutex lock
    Mutex _Feedback_5_Value_Mutex;//Feedback sensor 5 mutex lock
    Mutex _Feedback_6_Value_Mutex;//Feedback sensor 6 mutex lock
};
#endif //_FEEDBACK_