#include "Serial_Board.hpp"

SERIAL_BOARD::SERIAL_BOARD()//Constructor
{
    _POST_Value_Mutex.lock();
    _POST_Value = 77;//Need a post test value to get a echo confirm
    _POST_Value_Mutex.unlock();
    _Received_Data_Mutex.lock();
    _Received_Data = 0;//Set data to 0
    _Received_Data_Mutex.unlock();
    _Output_Data_Mutex.lock();
    _Output_Data = 0;//Set the output data to 0
    _Output_Data_Mutex.unlock();
}
SERIAL_BOARD::~SERIAL_BOARD(){}//Destructor
void SERIAL_BOARD::Init(){}
int SERIAL_BOARD::Post()
{   
    _POST_Value_Mutex.lock();
    _Received_Data_Mutex.lock();
    Board.printf("%d\n", _POST_Value);
    Board.scanf("%d", &_Received_Data);
    _POST_Value_Mutex.unlock();
    _Received_Data_Mutex.unlock();
    if(_POST_Value == _Received_Data)
    {
        return 1;//Pass
    }
    else
    {
        return 0;//Fail
    }
}
void SERIAL_BOARD::Main()
{
    if(PC.readable())
    {
        PC.printf("In Serial board\n");
    }
    while(1)
    {
        for(int loop = 0; loop < 16; loop++)
        {
            _Output_Data_Mutex.lock();
            _Received_Data_Mutex.lock();
            _Output_Data = _Output_Data + 1;
            Board.printf("%d\n", _Output_Data);
            Board.scanf("%d", &_Received_Data);
            PC.printf("Data is %d\n",_Received_Data);
            _Output_Data_Mutex.unlock();
            _Received_Data_Mutex.unlock();
            Thread::wait(1000);
        }
    _Output_Data = 0;
    Thread::wait(1000);
    }
}
