#ifndef _INTERFACE_HPP_
#define _INTERFACE_HPP_

#include "mbed.h"
#include "rtos.h"
#include "TextLCD.h"

//Libraries and header file includes


extern Serial PC;    //TX, RX
extern Serial Board; //TX, RX
extern TextLCD Lcd; // rs, e, d4-d7
//extern DigitalOut On_board_led;//Onboard LED
class INTERFACE
{
    public://Public member functions and variables
    INTERFACE(PinName N1, PinName N2, PinName N3, PinName N4, PinName N5, PinName N6, PinName N7, PinName N8, PinName N9, PinName N10, PinName N11);
    ~INTERFACE();
    void Init();
    int Post();
    void Serial();
    void LCD();
    void On_board_LED_Flash();
    //Public Functions
    
    //Public Variabls
    
    private://Private member functions and variables
    //Inputs
    
    //Rotary Encoder
    DigitalIn _Rotary_Encoder_A;//N1
    DigitalIn _Rotary_Encoder_B;//N2
    DigitalIn _Rotary_Encoder_Button;//N3
    
    
    //Buttons
    DigitalIn _Button_1;//N4
    DigitalIn _Button_2;//N5
    DigitalIn _Button_3;//N6
  
    //MOSFET Safety Pin
    DigitalOut _MOSFET_Safety;//Active low N7
    
    //Shift Register Control
    DigitalOut _Shift_SCLK;//N8
    DigitalOut _Shift_Latch;//N9
    DigitalOut _Shift_Enable;//N10
    DigitalOut _Shift_Data;//N11

    
    //Private Functions
    
    //Private Variables
    //DigitalOut On_board_led;//Onboard LED
};
#endif //_INTERFACE_HPP_