#include "mbed.h"
#include "WebUI.h"
#include "Serial.h"
#include "Sampling.h"
#include "LCD.h"
#include "SDCard.h"
#include "SDBlockDevice.h"
#include "Logging.h"

//Hardware setup
BMP280 sensor(D14, D15);        //Enviromental sensor
AnalogIn LDRSensor(A0);         //LDR sensor      
DigitalOut SamplingLED(PB_10);  //LED to indicate sampling
             
//SD Card devices
InterruptIn SD_WP(PE_10);
InterruptIn UserButton(USER_BUTTON);
SDBlockDevice sd(PB_5, D12, D13, D10);
DigitalOut GreenLED(PB_11);

//Serial interface
Serial PC(USBTX, USBRX);    

//LCD card object. LCD pins and two timeset buttons
ENVDISPLAY lcd(D9, D8, D7, D6, D4, D2,PE_12, PE_14);  

//Forward Declaration of Self Test
void POST(void); 

int main()
{
    //Initialise devices
    firstSample = true; //Set only at start of program
    logging = false;
    
    //Hardware Self Test
    POST();

    //Initialise interrupts and times
    SerialStart();        //Start serial comms
    lcd.Start();          //Start LCD functionality
    SDCardInit();         //Start SDCard functionality
    WebUISetup();         //Start Web Interface
    ConfigThreadsAndIR(); //Start sampling


    //Run
    while (true) {
        if (NewEnvSample && NewLDRSample) {
            //New samples have been captured and are in the register
            IncrementIndex();       //Index for buffers
            NewEnvSample = false;   //Reset sampling threads
            NewLDRSample = false;

            //Push latest samples to LCD.
            lcd.UpdateData(tempReadings[currentIndex],presReadings[currentIndex],LDRReadings[currentIndex],timeReadings[currentIndex]);
            LogEvent(Log_IndexInc);   //Log position
        }
        if (logging) {
            //Grab from mailbox and print to serial
            string QueueData = CheckLoggingQueue(); //Get the data from queue
            char char_array[QueueData.length()+1];  //Char array for message
            strcpy(char_array, QueueData.c_str());  //String must be converted to char array for printf
            PC.printf("%s\n\r",char_array);
        }
    }
}

void POST(void)
{
    printf("------Self Test------\n\r");
    lcd.POST();
    printf("LCD Test Done\n\r");
    printf("SDCard ejected?: %d\n\r",SD_WP.read());
    printf("SDCard Dismount Button: %d\n\r",UserButton.read());
    printf("Flashing SDCard Status LEDs\n\r");
    int i;
    for (i=0;i<5;i++){  //Flash the LEDs
        GreenLED = 1;
        SDCardStatusLED = 0;
        Thread::wait(200);
        GreenLED = 0;
        SDCardStatusLED = 1;
        Thread::wait(200);
    }
    SDCardStatusLED = 0;
    printf("Temp: %5.1fC\n\r",sensor.getTemperature());   //Print temperature
    printf("Pres: %5.1fmBar\n\r",sensor.getPressure());   //Print Pressure
    printf("LDR: %f\n\r",LDRSensor);  //Print Light Level
    printf("Flashing Sample LED\n\r");
    for (i=0;i<5;i++){  //Flash the LED
        SamplingLED = 1;
        Thread::wait(200);
        SamplingLED = 0;
        Thread::wait(200);
    }
    SamplingLED = 0;
    printf("------Self Test Complete------\n\r");
    Thread::wait(1000);
}
