#if !FEATURE_LWIP
#error [NOT_SUPPORTED] LWIP not supported for this target
#endif
//We need to look into what if statements like the one above do.
#include "WebUI.h"
#include "mbed.h"
#include "Sampling.h"

Thread WebThread;
//Now setup a web server
TCPServer srv;           //TCP/IP Server
TCPSocket clt_sock;      //Socket for communication
SocketAddress clt_addr;  //Address of incoming connection
EthernetInterface eth;
using namespace std;

#define HTTP_STATUS_LINE "HTTP/1.0 200 OK"
#define HTTP_HEADER_FIELDS "Content-Type: text/html; charset=utf-8"
#define HTTP_MESSAGE_BODY1 ""                                    \
"<html>" "\r\n"                                                  \
"<title>Enviromental Readings</title>"               \
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <h1>Most Recent Readings:</h1>" "\r\n"                    \
"      <p><b>Time Taken:</b> "

#define HTTP_MESSAGE_BODY2 ""                                    \
       "</p>" "\r\n"                                             \
"    </div>" "\r\n"                                              \
"  </body>" "\r\n"                                               \
"</html>"

#define HTTP_RESPONSE HTTP_STATUS_LINE "\r\n"   \
                      HTTP_HEADER_FIELDS "\r\n" \
                      "\r\n"                    \
                      HTTP_MESSAGE_BODY "\r\n"

#define IP        "10.0.0.10"
#define NETMASK   "255.0.0.0"
#define GATEWAY   "10.0.0.1"

void WebUISetup(void)
{
    //Configure an ethernet connection
    eth.set_network(IP, NETMASK, GATEWAY);
    eth.connect();
    
    PC.printf("The target IP address is '%s'\n\r", eth.get_ip_address());
    LogEvent(Log_EthConfig);

    /* Open the server on ethernet stack */
    srv.open(&eth);

    /* Bind the HTTP port (TCP 80) to the server */
    srv.bind(eth.get_ip_address(), 80);

    /* Can handle 5 simultaneous connections */
    srv.listen(5);
    WebThread.start(&WebUIUpdate);
}

void WebUIUpdate(void)
{
    while (true) {
        //Block and wait on an incoming connection
        srv.accept(&clt_sock, &clt_addr);
        
        LogEvent(Log_EthRequest); //Request recived

        //This string will hold the HTML that will be sent to the browser
        string response;
        //This will be a concatenation of several lines for each reading
        char time_str[64];
        char temp_str[64];
        char pres_str[64];
        char ldr_str[64];

        tm T = ReturnDateTimeStruct(timeReadings[currentIndex]);   //Convert time int to structure

        //Fill each string with values
        sprintf(time_str,"%4d/%2d/%2d %2d:%2d:%2d</p>\r\n",T.tm_year,T.tm_mon,T.tm_mday,T.tm_hour,T.tm_min,T.tm_sec);
        sprintf(temp_str,"<p><b>Temperature:</b> %5.1f C </p>\r\n", tempReadings[currentIndex]);
        sprintf(pres_str,"<p><b>Pressure:</b> %5.3f mBar </p>\r\n",presReadings[currentIndex]);
        sprintf(ldr_str, "<p><b>LDR:</b> %5.3f </p>\r\n", LDRReadings[currentIndex]);


        //Build the C++ string response
        response = HTTP_MESSAGE_BODY1;
        response += time_str;
        response += temp_str;
        response += pres_str;
        response += ldr_str;
        response += HTTP_MESSAGE_BODY2;

        //Send static HTML response (as a C string)
        clt_sock.send(response.c_str(), response.size()+6);
    }
}
