#include "mbed.h"
#include "TimeInterface.h"

void SetDate(int DD, int MM, int YYYY)
{
    time_t currentTime = time(0);   //Get the currenttime
    tm* current_tm = localtime(&currentTime);  //Convert the time integer to a stuct
    tm newtime = *current_tm;       //structure holding new time
    newtime.tm_year = YYYY - 1900;  //Year since 1900
    newtime.tm_mon = MM - 1;        //month of the year (0-11)
    newtime.tm_mday = DD;           //day of month
    //All other parameters remain unchanged
    
    int timeint = mktime(&newtime);  //Convert time strucutre to int
    if (timeint == -1)
    {
        //error code
    } else {
        set_time(timeint);  //Set the new time
    }
}

void SetTime(int HH, int mm, int ss)
{
    time_t currentTime = time(0);   //Get the currenttime
    tm* current_tm = localtime(&currentTime);  //Convert the time integer to a stuct
    tm newtime = *current_tm;       //structure holding new time
    
    newtime.tm_hour = HH;   //Set hours
    newtime.tm_min = mm;    //Set mins
    newtime.tm_sec = ss;    //Set secs
    //All other parameters remain unchanged
    
    int timeint = mktime(&newtime);  //Convert time strucutre to int
    if (timeint == -1)
    {
        //error code
    } else {
        set_time(timeint);  //Set the new time
    }
}

struct tm ReturnDateTimeStruct(time_t seconds)
{
    tm* ltm = localtime(&seconds);  //Turn given time integer into time structure pointer
    ltm->tm_mon += 1;    //adjust from the standard of 0-11 for months to 1-12
    ltm->tm_year += 1900;
    return *ltm;    //Return the data held at this address.
}