#ifndef __Serial__
#define __Serial__
/*
*This module handles all serial communications with a PC over USB. 
*Serial code is attached to its own thread and is run when the RX interrupt is triggered.
*The RX interrupt is triggered when someone starts typing in a PC terminal. 
*The Scanf function is then started to capture the input. 
*There are a list of commands that are used with serial:

* readall
* deleteall
* read <n>
* delete <n>
* setdate <dd><mm><yyyy>
* settime <hh><mm><ss>
* sett <T>
* state <x>
* logging <x>

*/

#include "mbed.h"
#include "Sampling.h"
#include "Logging.h"

//Variables
extern int DateTimeVar[3];  //Used for reading date or time from serial
extern bool SerialState;    //Used for toggling sampling
extern char InputBufferText[128];   //Buffer for incoming chars
extern unsigned short InputBufferNum;   //Buffer for incoming numbers
extern unsigned short internalIndex;    //Used for incrementing out sample data

//Objects
extern Thread SampleThread; 
extern Serial PC;

//Functions

void SerialStart(void);
//Initialising  serial interface

void RXInterruptISR(void);
//Function attached to the RX interrupt, sets SerialThread signal. 

void SerialCode(void);
//Code that runs in the SerialThread



#endif