#ifndef __WebUI__
#define __WebUI__

/*
* This module handles the web interface. WebUISetup() is used to configure the
* devices.
* WebUIUpdate() is then attached to a thread.
* This will wait on receiving a connection, before grabbing the latest samples
* and making these part of the HTML response.
*/
#include <string>
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"
#include "TimeInterface.h"
#include "Logging.h"
#include "Serial.h"
#include <iostream> 

extern Thread WebThread;
//Now setup a web server
extern TCPServer srv;           //TCP/IP Server
extern TCPSocket clt_sock;      //Socket for communication
extern SocketAddress clt_addr;  //Address of incoming connection

void WebUISetup(void);  //Configures the TCP server

void WebUIUpdate(void); //Might be called as a string, but does have blocking currently.

#endif