#include "mbed.h"
/*
* These functions provide an easy way to set and read the onboard time of day clock.
* At start, the clock will read 1970 and so needs to be set for meaningful values.
* Time is returned in a tm data strucure. Variables held in the structure are
* listed at the bottom of the header file.
*/
void SetDate(int DD, int MM, int YYYY);
//Sets the given date as system date. Does not modify time.

void SetTime(int HH, int mm, int ss);

struct tm ReturnDateTimeStruct(time_t seconds);
//Returns a time structure from the integer time given.
//Passing in time(0) will pass in the current system time.

/* tm structure:
*struct tm {
*   int tm_sec;   // seconds of minutes from 0 to 61
*   int tm_min;   // minutes of hour from 0 to 59
*   int tm_hour;  // hours of day from 0 to 24
*   int tm_mday;  // day of month from 1 to 31
*   int tm_mon;   // month of year from 1 to 12 (customised)
*   int tm_year;  // year since 1900 (customised)gives acctual year
*   int tm_wday;  // days since sunday
*   int tm_yday;  // days since January 1st
*   int tm_isdst; // hours of daylight savings time
*}
tm T = ReturnDateTimeStruct(3456784567);
T.tm_hour;

*/