#include "mbed.h"
#include "LCD.h"
#include "DriverLCD.h"
#include "rtos.h"

using namespace std;
//Initalise TextLCD and button1 before constructor.
ENVDISPLAY::ENVDISPLAY(PinName rsPin, PinName rePin, PinName d4Pin, PinName d5Pin, PinName d6Pin, PinName d7Pin, PinName Button1Pin, PinName Button2Pin) : DriverLCD(rsPin, rePin, d4Pin, d5Pin, d6Pin, d7Pin), Button1(Button1Pin), Button2(Button2Pin)
{
    //constructor. Initalise variables
    _latestTemp = 0.0;
    _latestPres = 0.0;
    _latestLDR = 0.0;
    _latestTime = 0;
    _currentState = SCROLLREADINGS;
}


void ENVDISPLAY::SendMessage(char sentText[], bool returnToReadings)
{
    if (strlen(sentText)>32) {
        //overflow error
        LogEvent(Log_LCDOverflow);
    } else {
        std::copy( sentText, sentText+strlen(sentText), _message ); //store inputted message to _message
        _AutoQuit = returnToReadings;   //Set AutoQuitState
        _currentState = MESSAGE;    //Change LCD state to show message
    }
}


void ENVDISPLAY::UpdateData(float temp, float pres, float LDR, time_t sampleTime)
{
    _latestTemp = temp;
    _latestPres = pres;
    _latestLDR = LDR;
    _latestTime = sampleTime;
}


void ENVDISPLAY::StateMachine(void)
{
    while (true) {
        cls();  //clear LCD
        switch (_currentState) {
            case SCROLLREADINGS:
                LogEvent(Log_LCDScroll);   //Log position

                tm T = ReturnDateTimeStruct(_latestTime);   //Get a time structure
                printf("Temp: %5.1fC\n",_latestTemp);   //Print temperature
                printf("Pres: %5.1fmBar\n",_latestPres);//Print Pressure
                Thread::wait(SCREENDELAY_MS);   //Hold screen for specified time
                cls();  //Clear screen
                printf("LDR: %4.3f\n",_latestLDR);  //Print Light Level
                printf("%2d/%2d %2d:%2d:%2d\n",T.tm_mday,T.tm_mon,T.tm_hour,T.tm_min,T.tm_sec); //Print time DD/MM HH:mm:ss
                Thread::wait(SCREENDELAY_MS);   //Hold screen for specified time
                break;

            case MESSAGE:
                LogEvent(Log_LCDMessage);   //Log position
                printf("%s\n",_message);    //Print custom message to display
                Thread::wait(SCREENDELAY_MS);//Hold screen for specified time
                if (_AutoQuit) {
                    //If it has been specified to return to scroll readings:
                    _currentState = SCROLLREADINGS; //Change state
                    memset(_message, 0, 32*sizeof(char));    //Wipe message
                }
                //Else stay in message state.
                break;

            case ADJUSTTIME:
                _EditTime = ReturnDateTimeStruct(time(0));          //Get system time as structure
                Thread::signal_clr(1);      //Clear any flags that have already been set
                strcpy(_editingInTime, "Day");                      //Say what we will be adjusting
                _EditTime.tm_mday = TimeEditor(_EditTime.tm_mday, 31,1); //Enter time set loop then update value in structure
                strcpy(_editingInTime, "MM");                    //Say what we will be adjusting
                _EditTime.tm_mon = TimeEditor(_EditTime.tm_mon, 12,1); //Enter time set loop then update value in structure
                strcpy(_editingInTime, "Year");                    //Say what we will be adjusting
                _EditTime.tm_year = TimeEditor(_EditTime.tm_year, 2020,1996); //Enter time set loop then update value in structure
                strcpy(_editingInTime, "Hour");                    //Say what we will be adjusting
                _EditTime.tm_hour = TimeEditor(_EditTime.tm_hour, 23,0); //Enter time set loop then update value in structure
                strcpy(_editingInTime, "Mins");                    //Say what we will be adjusting
                _EditTime.tm_min = TimeEditor(_EditTime.tm_min, 59,0); //Enter time set loop then update value in structure

                SetDate(_EditTime.tm_mday, _EditTime.tm_mon, _EditTime.tm_year);    //Set system date
                SetTime(_EditTime.tm_hour, _EditTime.tm_min, 0);
                SendMessage("Time and date   set",true);
                break;
        }
    }
}

void ENVDISPLAY::Start(void)
{
    LCDThread.start(this, &ENVDISPLAY::StateMachine);  //Start thread
    this->Button1.rise(this, &ENVDISPLAY::Button1ISR); //Initalise button interrupt
    this->Button2.rise(this, &ENVDISPLAY::Button2ISR); //Initalise button interrupt
    SendMessage("Starting...",true);                   //WRite message
}

void ENVDISPLAY::Button1ISR(void)
{

    But1Debouncer.attach(this, &ENVDISPLAY::But1DebouncerISR,0.2); //Start debouncer
}

void ENVDISPLAY::Button2ISR(void)
{
    But2Debouncer.attach(this, &ENVDISPLAY::But2DebouncerISR,0.2); //Start debouncer
}

void ENVDISPLAY::But1DebouncerISR(void)
{
    
    _but1Pressed = true;    //Signal Button 1 as pressed
    _currentState = ADJUSTTIME;//Change State machine
    LCDThread.signal_set(1);//Signal to thread to continue
}

void ENVDISPLAY::But2DebouncerISR(void)
{
    _but2Pressed = true;
    LCDThread.signal_set(1);
}

int ENVDISPLAY::TimeEditor(int changingVal, int upperLimit, int lowerLimit)
{
    _but1Pressed = false;       //Set switches to 'not been pushed'
    _but2Pressed = false;
    while (!_but2Pressed) {
        cls();          //Clear the screen
        printf("Adjust The %s\n",_editingInTime);   //print value to screen
        printf("%2d\n",changingVal);
        _but1Pressed = false;       //Prevent against the buttons having been pushed early
        _but2Pressed = false;
        Thread::signal_wait(1); //Wait for a button to be pushed

        if (_but1Pressed) {
            //Then user wants to increment
            if ((changingVal+1) > upperLimit) {
                changingVal = lowerLimit;   //overflow so loop
            } else {
                changingVal += 1;  //incrment
            }
            _but2Pressed = false;   //Button 1 was pressed so 2 must not have been
        } else {
            //Button 2 has been pressed so user wants to step forward.
            //This will exit while loop and move to next step
        }
    }
    memset(_editingInTime, 0, 10*sizeof(char));    //Clear the variable name
    return changingVal;     //Return the new number.
}

void ENVDISPLAY::POST(void)
{
    cls();  //Clear screen
    printf("B1: %d\n",Button1.read());  //Display button 1 state
    printf("B2: %d\n",Button2.read());  //Display button 2 state
} 