#include "DriverLCD.h"
#include "mbed.h"

DriverLCD::DriverLCD(PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7) : _rs(rs),_e(e), _d(d4, d5, d6, d7)
{

    _e  = 1;    //Enable high, rs low to enter command mode
    _rs = 0;

    wait(0.015);        //Wait 15ms for LCD to powerup

    for (int i=0; i<3; i++) {   //Send command 3 times
        LCD_DATA(0x3,INIT);
        wait(0.002);            //Wait 2ms, so wait for it
    }
    LCD_DATA(0x2,INIT);         //4-bit mode
    wait(0.000040f);            //Wait 40us

    LCD_DATA(0x28,CMD);         //Function set. 2 lines, 5x8 dots, 1/16 dusy factor
    LCD_DATA(0x0C,CMD);         //Turn Display on
    LCD_DATA(0x6,CMD);          //Entry mode setting. Standard increment
    cls();                      //Clear display
}

void DriverLCD::cls()
{
    LCD_DATA(0x01,CMD); //Clear display command.
    wait(0.002);        //Wait 2ms
    locate(0, 0);       //Resets cursor to 0,0
}

void DriverLCD::locate(int column, int row)
{
    _column = column;   //Set new column and row data to internal variables
    _row = row;
}

void DriverLCD::LCD_DATA(int data,int command)
{
    if(command == 0) {           //CMD = 0, enter command mode
        _rs = 0;
    } else if (command == 1) {   //STR = 1
        _rs = 1;
    }

    _d = data >> 4; //Send most significant nibble first
    wait(0.00004);  //Wait 40us
    _e = 0;         //Clock enable line to put in data
    wait(0.00004);
    _e = 1;
    
    _d = data >> 0; //Send least significant nibble seccond
    wait(0.00004);
    _e = 0;
    wait(0.00004);
    _e = 1;
}

void DriverLCD::character(int column, int row, int data)
{
    int addr = 0x80 + (row * 0x40) + column;   //Calculate address of segment
    LCD_DATA(addr,CMD); //Move cursor to new address
    LCD_DATA(data,STR); //Write data
}


int DriverLCD::_putc(int data)
{
    if (data == '\n') { //If new line is found, move down a row
        _column = 0;    //Reset to first column
        _row++;         //inc row
        if (_row >= 2) {//Only two rows on this LCD, move up a row instead.
            _row = 0;
        }
    } else {
        character(_column, _row, data); //Write char
        _column++;                      //Then increment column and row to next location
        if (_column >= 16) {
            _column = 0;
            _row++;
            if (_row >= 2) {
                _row = 0;
            }
        }
    }
    return data;
}

int DriverLCD::_getc()
{
    return -1;
}


