#include "Serial.h"
#include "mbed.h"
#include "Sampling.h"
#include "TimeInterface.h"
#include "Logging.h"

#include <string>

Thread SerialThread;

//Variables
int DateTimeVar[3];
bool SerialState;
char InputBufferText[128];
unsigned short InputBufferNum;
unsigned short internalIndex;

//float tempReadingsSerial[BUFFERSIZE] = {};
//float presReadingsSerial[BUFFERSIZE] = {};
//float LDRReadingsSerial[BUFFERSIZE] = {};
//time_t timeReadingsSerial[BUFFERSIZE] = {};


void SerialStart(void)
{
    SerialThread.start(&SerialCode);   //Start thread running 
    Thread SerialThread(osPriorityNormal, 32 * 1024);  //Normal priority with a 32k stack size 
    PC.attach(&RXInterruptISR); //Attach interrupt function to hardware interrupt
}


void RXInterruptISR(void)
{
    SerialThread.signal_set(1); //Set thread signal to start SerialCode
    PC.attach(NULL); //Disable interrupt
}


void SerialCode(void)
{
    while(true) {
        Thread::signal_wait(1);          //Wait untill signal set
        PC.scanf("%s", InputBufferText); //Scan serial
        PC.printf("Command: %s\n\r", InputBufferText); //Print input string. Readback

        string InputBufferString(InputBufferText); //Convert array of char to string


        if (InputBufferString == "test") {
            //Test function
            PC.printf("testsuccess\n\r");


        } else if (InputBufferString == "help") {
            //Help function
            PC.printf("Here is an usefull list of commands:\n\r");
            PC.printf(" readall\n\r deleteall\n\r read <n>\n\r delete <n>\n\r setdate <dd><mm><yyyy>\n\r settime <hh><mm><ss>\n\r sett <T>\n\r state <x>\n\r logging <x>\n\r");


        } else if (InputBufferString == "readall") {
            //Reads all samples in buffers and prints oldest first
            Sampling(false); //Stop sampling
            internalIndex = currentIndex; //InternalIndex for incrementing out data
            PC.printf("Printing all %d reccords\n\r",BUFFERSIZE);
            PC.printf("  Date  |  Time  | Temp | Pressure | Light\n\r");
            
            TakeKeys(true); //Take keys
            for (short i = 0; i < BUFFERSIZE; i++) { //For loop of length buffersize
                tm T = ReturnDateTimeStruct(timeReadings[internalIndex]);
                //InternalIndex was set as newest. We will now decrement to display oldest to newest
                PC.printf(" %4d/%2d/%2d    %2d:%2d:%2d    %2.2f     %2.2f     %2.2f\n\r",T.tm_year,T.tm_mon,T.tm_mday,T.tm_hour,T.tm_min,T.tm_sec,tempReadings[internalIndex],presReadings[internalIndex],LDRReadings[internalIndex]);
                //PC.printf("%d\n\r",T.tm_year);
                internalIndex = IndexDecrement(internalIndex); //Decrement internal index
            }

            TakeKeys(false); //Return keys
            Sampling(true);  //Start sampling


        } else if (InputBufferString == "deleteall") {
            //Deletes all reccords

            Sampling(false);//Stop sampling

            TakeKeys(true); //Take keys

            memset(tempReadings, 0.0, BUFFERSIZE * sizeof(float)); //Fill array with 0s
            memset(presReadings, 0.0, BUFFERSIZE * sizeof(float));
            memset(LDRReadings, 0.0, BUFFERSIZE * sizeof(float));
            memset(timeReadings, 0.0, BUFFERSIZE * sizeof(float));

            nextIndex = 0;   //Reset Index
            currentIndex = 0;
            oldestIndex = 0;

            firstSample = true;

            TakeKeys(false); //Return keys

            Sampling(true);  //Start sampling

            PC.printf("Deleted %d records\n\r",BUFFERSIZE);


        } else if (InputBufferString == "read") {
            //Reads past <n> records
            PC.printf("How many records would you like to view:\n\r");
            PC.attach(&RXInterruptISR);  //Enable interrupt
            Thread::signal_wait(1);      //Wait untill signal set

            PC.scanf("%d", &InputBufferNum); //Scan serial

            if (InputBufferNum >= BUFFERSIZE) { //If requested number of samples is greater than buffersize
                InputBufferNum = BUFFERSIZE;    //Then set number of samples equal to buffersize
            }

            internalIndex = currentIndex; //InternalIndex for incrementing out data
            PC.printf("Showing the newest %d records:\n\r", InputBufferNum);
            PC.printf("  Date  |  Time  | Temp | Pressure | Light\n\r");
            TakeKeys(true); //Take keys

            for (short i = 0; i < InputBufferNum; i++) { //For loop of length InputBufferNum
                tm T = ReturnDateTimeStruct(timeReadings[internalIndex]);
                PC.printf(" %4d/%2d/%2d    %2d:%2d:%2d    %2.2f     %2.2f     %2.2f\n\r",T.tm_year,T.tm_mon,T.tm_mday,T.tm_hour,T.tm_min,T.tm_sec,tempReadings[internalIndex],presReadings[internalIndex],LDRReadings[internalIndex]);
                internalIndex = IndexDecrement(internalIndex); //Decrement internal index
            }
            TakeKeys(false); //Return keys


        } else if (InputBufferString == "delete") {
            //Deletes oldest <n> records
            PC.printf("How many records would you like to delete:\n\r");
            PC.attach(&RXInterruptISR); //Enable interrupt
            Thread::signal_wait(1);      //Wait untill signal set

            PC.scanf("%d", &InputBufferNum); //Scan serial
            Sampling(false);  //Stop sampling
            TakeKeys(true); //Take keys

            for (int i = 0; i < InputBufferNum; i++) {
                tempReadings[oldestIndex] = 0; //Fill array with 0s
                presReadings[oldestIndex] = 0;
                LDRReadings[oldestIndex] = 0;
                timeReadings[oldestIndex] = 0;

                oldestIndex = IndexIncrement(oldestIndex); //Increment index
            }

            TakeKeys(false); //Return keys
            Sampling(true);  //Start sampling
            PC.printf("Deleated %d records", InputBufferNum); //Scan serial


        } else if (InputBufferString == "setdate") {
            //Set date YYYY/MM/DD
            Sampling(false);  //Stop sampling
            PC.printf("Setting Date\n\r");

            for (int i = 0; i < 3; i++) { //Changes message on each iteration
                if (i==0) {
                    PC.printf("Input Year <YYYY>:\n\r");
                } else if(i==1) {
                    PC.printf("Input Month <MM>:\n\r");
                } else if (i==2) {
                    PC.printf("Input Date <DD>:\n\r");
                }

                PC.attach(&RXInterruptISR);  //Enable interrupt
                Thread::signal_wait(1);      //Wait untill signal set

                PC.scanf("%d", &DateTimeVar[i]); //Scan serial
            }

            SetDate(DateTimeVar[2], DateTimeVar[1], DateTimeVar[0]); //Set date
            PC.printf("Date set to : %d/%d/%d",DateTimeVar[2], DateTimeVar[1], DateTimeVar[0]);
            Sampling(true);  //Stop sampling


        } else if (InputBufferString == "settime") {
            //Set time hh/mm/ss
            Sampling(false);  //Stop sampling
            PC.printf("Setting Time\n\r");

            for (int i = 0; i < 3; i++) { //Changes message on each iteration
                if (i==0) {
                    PC.printf("Input Hour <hh>:\n\r");
                } else if(i==1) {
                    PC.printf("Input Minute <mm>:\n\r");
                } else if (i==2) {
                    PC.printf("Input Seccond <ss>:\n\r");
                }

                PC.attach(&RXInterruptISR);  //Enable interrupt
                Thread::signal_wait(1);      //Wait untill signal set

                PC.scanf("%d", &DateTimeVar[i]); //Scan serial
            }

            SetTime(DateTimeVar[0], DateTimeVar[1], DateTimeVar[2]); //Set time
            PC.printf("Time set to : %d:%d:%d",DateTimeVar[0], DateTimeVar[1], DateTimeVar[2]);
            Sampling(true);  //Stop sampling


        } else if (InputBufferString == "sett") {
            //Set sample rate
            PC.printf("What would you like to set the sample rate to:\n\r");
            PC.attach(&RXInterruptISR);  //Enable interrupt
            Thread::signal_wait(1);      //Wait untill signal set

            PC.scanf("%d", &SAMPLERATE); //Scan serial

            ConfigThreadsAndIR(); //Reattach ticker

            PC.printf("Sample rate set to: %d\n\r",SAMPLERATE);


        } else if (InputBufferString == "state") {
            //Toggle sampling
            SerialState = !SerialState; //Toggle state
            if (SerialState) {
                Sampling(true); //Start sampling
                PC.printf("Sampling started\n\r");
            } else {
                Sampling(false);//Stop sampling
                PC.printf("Sampling stopped\n\r");
            }



        } else if (InputBufferString == "logging") {
            //Toggle logging
            logging = !logging; //Toggle state
            if (logging) {
                PC.printf("Logging started");
            } else {
                PC.printf("Logging stopped");
            }
        }


        PC.attach(&RXInterruptISR); //Enable interrupt
    }
}