#include "mbed.h"
#include "Sampling.h"
#include "SDCard.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "LCD.h"


//Hardware
DigitalOut SDCardStatusLED(LED3);

//Variables
bool SDCardPresent;
bool SDCardMounted;
unsigned short SDinternalIndex;

FILE* fp; //File pointer type
SDCardStates SDCurrentState;    //Create state machine state

Timeout antiBounce;
Thread SDCardThread;
FATFileSystem fs;


void SDCardInit(void)
{
    SDCardThread.start(&SDCardCode);   //Start thread running
    SD_WP.rise(&SDCardRemovedISR);     //SD removed
    SD_WP.fall(&SDCardInsertedISR);    //SD inserted
    UserButton.fall(&SDCardButtonISR); //Button released

    if (SD_WP == 1) {               //Checks if card is inserted on power up and sets states
        SDCardPresent = false;
        SDCurrentState = REMOVED;
        SDCardMounted = false;
    } else {
        SDCardPresent = true;
        SDCurrentState = INSERTED;
        SDCardMounted = false;
    }
}


//-----------------------------------------------------------------//
//ISRs
void SDCardRemovedISR(void)
{
    SDCardPresent = false;
    SDCurrentState = REMOVED;
    antiBounce.attach(&antiBounceISR,1);
}

void SDCardInsertedISR(void)
{
    SDCardPresent = true;
    SDCurrentState = INSERTED;
    antiBounce.attach(&antiBounceISR,1);

}

void SDCardButtonISR(void)
{
    SDCurrentState = DISMOUNTREQUEST;
    antiBounce.attach(&antiBounceISR,1);
}
//-----------------------------------------------------------------//

void antiBounceISR(void)
{
    SDCardThread.signal_set(1);
}


void SDCardCode(void)
{
    while(true) {
        Thread::signal_wait(1);    //Wait untill signal set

        if (SDCurrentState == REMOVED) {

            if (SDCardMounted) {
                //print error message file currupt
                lcd.SendMessage("SD CARD REMOVED!  FILE CORRUPT",true);
                SDCardMounted = 0;
            }
            LogEvent(Log_SDRemoved);
            SDCardStatusLED = 0;    //Set LEDs
            GreenLED = 0;



        } else if (SDCurrentState == INSERTED) {
            LogEvent(Log_SDInserted);
            SDCardStatusLED = 0;    //Set LEDs
            GreenLED = 0;

            if ( sd.init() != 0) { //Initalises the SDCard and checks if it succeeded
                //SDInit failed. Reinsert the SDCard
                lcd.SendMessage("REINSERT SDCARD",true);
                LogEvent(Log_SDInitFail);

            } else {

                //Create a filing system for SD Card
                FATFileSystem fs("sd", &sd);

                //Open to WRITE
                fp = fopen("/sd/samples.csv","w");


                if (fp == NULL) {
                    //error
                    lcd.SendMessage("CANNOT OPEN FILE/sd/samples.csv",true);
                    LogEvent(Log_SDFileOpenFail);

                } else {
                    SDCardMounted = true;   //SD card is now mounted

                    Sampling(false);    //Stop sampling
                    SDinternalIndex = currentIndex; //SDinternalIndex for incrementing out data
                    TakeKeys(true);     //Take keys

                    fprintf(fp,"Date,Time,Temperature,Pressure,Light\n");
                    for (short i = 0; i < BUFFERSIZE; i++) { //For loop of length buffersize
                        tm T = ReturnDateTimeStruct(timeReadings[SDinternalIndex]);
                        //SDinternalIndex was set as newest. We will now decrement to display oldest to newest
                        fprintf(fp," %4d/%2d/%2d,%2d:%2d:%2d,%2.2f,%2.2f,%2.2f\n",T.tm_year,T.tm_mon,T.tm_mday,T.tm_hour,T.tm_min,T.tm_sec,tempReadings[SDinternalIndex],presReadings[SDinternalIndex],LDRReadings[SDinternalIndex]);
                        SDinternalIndex = IndexDecrement(SDinternalIndex); //Decrement internal index
                    }
                }
                TakeKeys(false); //Return keys
                Sampling(true);  //Start sampling


                fclose(fp);         //Close file
                SDCardStatusLED = 1;//Set light to indicate SD card file transfer complete.
            }

        } else if (SDCurrentState == DISMOUNTREQUEST) {

            if (SDCardMounted) {
                sd.deinit();    //De initalise SD card
                SDCardMounted = false;  //Card now not mounted
                lcd.SendMessage("REMOVE SD CARD",true); //SD card can be removed
                GreenLED = 1;   //Indication LED
                LogEvent(Log_SDDeInit);
            } else {
                lcd.SendMessage("NO SD CARD  TO REMOVE",true);
                LogEvent(Log_SDDismountFail);
            }

        }
    }
}



