#include "Logging.h"
#include <string>

using namespace std;
Mail<uint32_t,32> ActivityLog;  //Mail Queue passes logging data
bool logging = false;           //Are we logging or not

void LogEvent(uint32_t eventCode)
{
    if (logging) {  //Only do if logging is enabled
        uint32_t* Status = ActivityLog.alloc(); //Allocate space in mailbox
        *Status = eventCode;    //Move data into memory
        ActivityLog.put(Status);//data is in queue 
    }
}

string CheckLoggingQueue(void)
{
    string returnString = "";
    if (logging) {  //Only do if logging is enabled
        osEvent evt = ActivityLog.get(5000);    //Get the object from mailbox. This blocks until there is data. Timeout after 5 secconds
        if (evt.status == osEventMail) {
            //Does it have content? If not, there is no mail.
            uint32_t* mail = (uint32_t*)evt.value.p;    //Extract the value passed
            //Convert int value to string
            char intStr[4]; //Has to be done in two steps because of known to_string bug stackoverflow.com/questions/12975341
            sprintf(intStr, "%d", *mail);
            string mailAsString = string(intStr);
            ActivityLog.free(mail);     //Now we can release the space in the mailbox
            returnString = "Data Logged:\n\r" + mailAsString;
            return returnString;
        } else {  
            //There wasn't any data            
            string returnString = "ERROR: There wasn't any data";
        }
    }
    return returnString;
}