#ifndef __DriverLCD__
#define __DriverLCD__

#include "mbed.h"

/*
* This module handles the low level control of a 16x2 LCD.
* It contains a class structure, and allows for text to be written to the LCD. 
* Text can be written by using printf, achived by including virtual Stream.
*/

//Datasheet sparkfun.com/datasheets/LCD/HD44780.pdf

#define CMD 0
#define STR 1
#define INIT 2

class DriverLCD : public Stream
{
public:

    DriverLCD(PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7);
    //Constructor

    void locate(int column, int row);
    //Moves cursor to specific position
    
    void cls();
    //Clear LCD

protected:

    // Stream implementation functions
    virtual int _putc(int data);
    virtual int _getc();

    void character(int column, int row, int data);
    //Writes a char to the display at set coordinates 

    void LCD_DATA(int data,int command);
    //Configure LCD state


    DigitalOut _rs, _e; //Write and command pins
    BusOut _d;          //Data out

    int _column;    //Internal position store
    int _row;
};

#endif