#ifndef __SDCard__
#define __SDCard__
/*
*
*/
#include "mbed.h"
#include "Sampling.h"
#include "SDCard.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "LCD.h"
#include "Logging.h"

//Hardware devices
extern InterruptIn SD_WP;          //Pin that indicates if the card has been inserted (active low)
extern InterruptIn UserButton;     //Demount request
extern SDBlockDevice sd;           //SD Card device
extern DigitalOut GreenLED;        //Shows its safe to demount
extern DigitalOut SDCardStatusLED; //Shows if the card is inserted

enum SDCardStates{INSERTED,REMOVED,DISMOUNTREQUEST};

//Variables
extern bool SDCardPresent;  //Is the SD card inserted?
extern bool SDCardMounted;  //Is the SD card initialised?
extern unsigned short SDinternalIndex;//Used for clocking out the data from the sample index
extern SDCardStates SDCurrentState; //State machine state

extern Thread SDCardThread;

//Functions
void SDCardInit(void);
//Starts the thread and sets up the interrupts
void SDCardRemovedISR(void);
//Interrupt runs when SD card is removed
void SDCardInsertedISR(void);
//Interrupt runs when SD card is inserted
void SDCardButtonISR(void);
//Interrupt runs when user button is pressed
void SDCardCode(void);
//Thread code which handles writing to SD card
void antiBounceISR(void);
//Prevent button bounce

#endif