#ifndef __Logging__
#define __Logging__

/*
* This module provides the logging functionality of the system.
* The LogEvent function is inserted into the code at key points, passing an
* integer value which represents the state. These are listed in the #defines
* below.
* The values are then insterted into a mailbox, where they fetched by the
* CheckLoggingQueue function. This returns a string which also has a suffix
* indicating logging. This can then be outputted to an interface. This function
* should be placed within a repeating thread. To use the function with a printf
* statement, you must convert between string and char array using:

string QueueData = CheckLoggingQueue(); //Get the data from queue
char char_array[QueueData.length()+1];  //Char array for message
strcpy(char_array, QueueData.c_str());  //String must be converted to char array for printf
PC.printf("%s\n\r",char_array); 

* Functions incorporate a check on the state of Logging before acting. CheckLoggingQueue
* will return an empty string if there is no logging.
*/
#include "mbed.h"
#include "rtos.h"
#include <string>

#define Log_SampleTicker 0
#define Log_EnviromSampled 1
#define Log_TimeSampled 2
#define Log_IndexInc 3 
#define Log_OldestInc 4 
#define Log_LCDScroll 5 
#define Log_LCDMessage 6 
#define Log_LCDTime 7 
#define Log_LCDOverflow 8
#define Log_LCDNoData 9
#define Log_SetDateFail 10 
#define Log_SetTimeFail 11
#define Log_EthConfig 12
#define Log_EthRequest 13
#define Log_SDInitFail 14
#define Log_SDFileOpenFail 15
#define Log_SDRemoved 16
#define Log_SDInserted 17
#define Log_SDDeInit 18
#define Log_SDDismountFail 19

extern Mail<uint32_t,32> ActivityLog;   //Mailbox that holds the activity

extern bool logging;
//Has logging been enabled in the system?
void LogEvent(uint32_t eventCode);
//Producer function - adds state to queue
string CheckLoggingQueue(void);
//Consumer function - wraps the number into a string with a suffix.
#endif