#ifndef __LCD__
#define __LCD__

#include "mbed.h"
#include "DriverLCD.h"
#include "rtos.h"
#include "TimeInterface.h"
#include "Logging.h"
#include <string>
/*
*The ENVDISPLAY class enhances the abilities of the TextLCD class to be
*relevant for an ENVIRONMENTAL sensor.
*Temperature, pressure, LDR and time readings are passed into the object using
*the UpdateData function. A custom message can also be displayed using
*SendMessage, with the option of returning to enviromental data.
*
*Two buttons are required for time setting functions. Pressing button 1 enters
*the lcd into a set_time state.
*
*Device initialised with: ENVDISPLAY lcd(D9, D8, D7, D6, D4, D2,PE_12, PE_14);
*lcd.Start() must be run to begin operation.
*/

#define SCREENDELAY_MS 2707  //Delay for screen update

class ENVDISPLAY : DriverLCD  //Class inherits TextLCD
{
private:
    char _message[32];  //32 characters on display
    bool _AutoQuit;     //After a message, should the LCD return to enviromental?
    float _latestTemp;  //Latest sample data
    float _latestPres;
    float _latestLDR;
    time_t _latestTime;

    enum ThreadState {MESSAGE,SCROLLREADINGS,ADJUSTTIME};

    ThreadState _currentState; //State machine state

    //Hardware
    InterruptIn Button1;  //Buttons used for setting time
    InterruptIn Button2;
    Timeout But1Debouncer;//Button debouncers
    Timeout But2Debouncer;
    Thread LCDThread;     //Thread which LCD runs in

    void Button1ISR(void);
    //Called when button 1 is pressed.
    void But1DebouncerISR(void);
    //insures that only 1 button press signal is sent to thread
    void Button2ISR(void);
    //Called when button 2 is pressed. Sets _but2Pressed and thread flag
    void But2DebouncerISR(void);
    //insures that only 1 button press signal is sent to thread
    void StateMachine(void);
    //Gets attached to LCDThread
    int TimeEditor(int changingVal, int upperLimit, int lowerLimit);
    //Handles the cycle and user input to modify changingVal and return the updated number

    //Used for time editing
    bool _but1Pressed;  //Signals that button 1 has been pressed
    bool _but2Pressed;  //Signals that button 2 has been pressed
    tm _EditTime;       //used to hold time structure whilst editing
    char _editingInTime[10];//hold the string of what variable is to be edited


public:
    ENVDISPLAY(PinName rsPin, PinName rePin, PinName d4Pin, PinName d5Pin, PinName d6Pin, PinName d7Pin, PinName Button1Pin, PinName Button2Pin);
    //constructor
    void SendMessage(char sentText[], bool returnToReadings);
    //Display a custom message on the display with option to resume displaying readings
    void Start(void);
    //Inititates LCD activity
    void POST(void);
    //Self Test
    void UpdateData(float temp, float pres, float LDR, time_t sampleTime);
    //Pass in new enviromental data

};
extern ENVDISPLAY lcd;

#endif