#ifndef SETUP_HPP//Header Guards Prevents Multiple includes
#define SETUP_HPP

#include "stdio.h"
#include "string.h"
#include "mbed.h"
#include "rtos.h"
#include "TextLCD.h"
#include "iostream"
#include "rtos.h"
#include "STEPPER_MOTOR.hpp"
#include "Interface.hpp"

#define Debounce_Time 100//200 works fine
INTERFACE INTERFACE;
//If the code compiles GET IN THE BIN

    
//Digital Outputs
DigitalOut led1(LED1);
DigitalOut led2(LED2);


//Function forward declarations
void up_thread_function();
void down_thread_function();
void start_thread_function();
void function_thread_function();
void select_thread_function();
void Polling_thread_function();
//Thread Setups
Thread polling_thread;
Thread lcd_thread;
Thread led_thread;
Thread up_thread;
Thread down_thread;
Thread start_stop_thread;
Thread function_thread;
Thread select_thread;
//LCD pin connections
TextLCD lcd(D0,D1,D4,D5,D6,D7); // rs, e, d4-d7

//Serial Terminal setup for debugging
Serial pc(USBTX, USBRX);         //Define serial namespace so the serial comms can be printed to

#endif 

//Useful information
/*
    Function 0 = Turn
    Function 1 = Anneal
    Function 2 = Test
    
    Black :Reset     : HardWired
    Red   :Up        : D8
    Orange:Down      : A1
    Brown :Start/Stop: D9
    Green :Select    : A3
    Yellow:Function  : A4
    
    
    //Led Outputs //check the pin outs.
    static DigitalOut Led_Select_Left(D2);
    static DigitalOut Led_Select_Right(D3);
    static DigitalOut Led_Power(A3);
  
    TextLCD lcd(D0,D1,D4,D5,D6,D7); // rs, e, d4-d7
    TendonPower (PWM) pin is PE_8  one below d0
    STEPPER_MOTOR STEPPER_MOTOR_1(D15,D14,D13,D12) this is defined in interface.hpp
*/
    