#ifndef INTERFACE_HPP//Header Guards Prevents Multiple includes
#define INTERFACE_HPP

#include "mbed.h"
#include "STEPPER_MOTOR.hpp" //Include this to use the stepper motor

#define Type_of_Rig 3 //Place 2 for coiling place 3 for twisting
#define Default_Coiling_Turns 20
#define Default_Twisting_Turns 70

//Digital In for the button control to the interface
static DigitalIn button_up(D8);    //D8//Increment Button
static DigitalIn button_down(A1);  //A1//Decrement Button
static DigitalIn button_start(D9); //D9//START / STOP BUTTON
static DigitalIn button_function(A3); //A3//Function Button
static DigitalIn button_select(A4);//A4//Select Button


//Led Outputs //check the pin outs
static DigitalOut Led_Select_Left(D3);
static DigitalOut Led_Select_Right(D2);
static DigitalOut Led_Power(A2);
static STEPPER_MOTOR STEPPER_MOTOR_1(D15,D14,D13,D12);
static PwmOut Tendon_Power(PE_8); 


class INTERFACE//This creates a class called Led
{ 
public: 
    //Public member variables

    //Public Member Functions
    INTERFACE(); //Constructor
    ~INTERFACE();//Destructor
    
    void Interface_Init();//Set all values to 0
    void Up();//Up Routine
    void Down();//Down Routine
    void Start_Stop();//Start / Stop Routine
    void Function();//Function Routine
    void Select();//Select Routine
    void Interface_main();//Main Routine

    //Setters to assign data to the private memeber variables
    void Set_System_Running(int System_Running);
    void Set_Function(int Function);
    void Set_Twist_Go(bool Twist_Go);
    void Set_Anneal_Go(bool Anneal_Go);
    void Set_Test_Go(bool Test_Go);
    void Set_Twist_Stop(bool Twist_Stop);
    void Set_Anneal_Stop(bool Anneal_Stop);
    void Set_Test_Stop(bool Test_Stop);
    void Set_Select(int Select);
    void Set_Turns_Done(int Turns_Done);
    void Set_Turns_To_Do(int Turns_To_Do);
    void Set_Loop(int Loop);
    void Set_On_Time(int On_Time);
    void Set_Off_Time(int Off_Time);
    void Set_Duty_Cycle(int Duty_Cycle);
    void Set_Power_Time(float Power_Time);
    
    //Getters to receive private information
    int Get_System_Running();
    int Get_Function();
    bool Get_Twist_Go();
    bool Get_Anneal_Go();
    bool Get_Test_Go();
    bool Get_Twist_Stop();
    bool Get_Anneal_Stop();
    bool Get_Test_Stop();
    int Get_Select();
    int Get_Turns_Done();
    int Get_Turns_To_Do();
    int Get_Loop();
    int Get_On_Time();
    int Get_Off_Time();
    int Get_Duty_Cycle();
    int Get_Power_Time();

private:    
    //Private member variables to prevent them being accessed externally 
    int _System_Running;
    int _No_Of_Rotations;
    int _Function;
    
    //Start
    bool _Twist_Go;
    bool _Anneal_Go;
    bool _Test_Go;
    
    //Stop
    bool _Twist_Stop;
    bool _Anneal_Stop;
    bool _Test_Stop;
    
    int _Select;
    int _Turns_Done;
    int _Turns_Todo;
    int _Loop;
    int _On_Time;
    int _Off_Time;//IN SECONDS
    int _Duty_Cycle;
    int _Power_Time;


    //Mutex Locks
    Mutex _System_Running_mutex;
    Mutex _No_Of_Rotations_mutex;
    Mutex _Function_mutex;
    Mutex _Twist_Go_mutex;
    Mutex _Anneal_Go_mutex;
    Mutex _Test_Go_mutex;
    Mutex _Twist_Stop_mutex;
    Mutex _Anneal_Stop_mutex;
    Mutex _Test_Stop_mutex;
    Mutex _Select_mutex;
    Mutex _Turns_Done_mutex;
    Mutex _Turns_Todo_mutex;
    Mutex _Loop_mutex;
    Mutex _On_Time_mutex;//IN SECONDS
    Mutex _Off_Time_mutex;
    Mutex _Duty_Cycle_mutex;
    Mutex _Power_Time_mutex;
    Mutex _Tendon_mutex;
    Mutex Led_Select_Left_mutex;
    Mutex Led_Select_Right_mutex;
    Mutex Led_Power_mutex;
};
#endif//INTERFACE_HPP