#include "SETUP.hpp"
void Polling_thread_function()// Polling thread to look for button press
{
    while(1)
    {
        if(button_up.read() == 0)               //This checks the Up button
        {
            printf("Up button read\n");
            Thread::wait(Debounce_Time);
            if(button_up.read() == 1)
            {   
                printf("Up button released\n");
                up_thread.signal_set(1);
            }   
        }
        if(button_down.read() == 0)               //This checks the Down button
        {
            printf("Down button read\n");
            Thread::wait(Debounce_Time);
            if(button_down.read() == 1)
            {
                down_thread.signal_set(1);
            }  
        }
        if(button_start.read() == 0)               //This checks the Start/Stop button
        {
            printf("Start/Stop button read\n");
            Thread::wait(Debounce_Time);
            if(button_start.read() == 1)
            {
                start_stop_thread.signal_set(1);
            }   
        }
        if(button_function.read() == 0)               //This checks the Function button
        {
            printf("Function button read\n");
            Thread::wait(Debounce_Time);
            if(button_function.read() == 1)
            {
                function_thread.signal_set(1);
            }   
        }
        if(button_select.read() == 0)               //This checks the Select button
        {
            printf("Select button read\n");
            Thread::wait(Debounce_Time);
            if(button_select.read() == 1)
            {
                select_thread.signal_set(1);
            }   
        }
        Thread::wait(50);   
    }   
}
void LCD_thread()   //Output data to the LCD for the interface
        /*
            This section of the code decides what data that should be sent to the LCD for each of the modes of the system.
        */
{
    while(1)
    {
        lcd.cls();//Clear the LCD screen
        if(INTERFACE.Get_Function() == 0)//Anneal Mode display
        {
            lcd.printf("Mode: Anneal\n");      //Top LCD line when the device is annealing
            if(INTERFACE.Get_Select() == 0 || INTERFACE.Get_Select() == 1)
            {
                lcd.printf("Loop:%d On_t:%d\n",INTERFACE.Get_Loop(),INTERFACE.Get_On_Time());   //When the On value is selected
            }
            else if(INTERFACE.Get_Select() == 2)
            {
               lcd.printf("Loop:%d Offt:%d\n",INTERFACE.Get_Loop(),INTERFACE.Get_Off_Time());   //When the Off value is selected
            }     
        }
        else if(INTERFACE.Get_Function() == 1)//Testing mode display
        {
            lcd.printf("Mode: Test\n");      //Top LCD line when the device is Testing
            lcd.printf("Duty: %dTime: %d\n",INTERFACE.Get_Duty_Cycle(),INTERFACE.Get_Power_Time());
        }
        else if(INTERFACE.Get_Function() == 2)//Coil
        {
            lcd.printf("Mode: Coil\n");      //Top LCD line when the device is Coiling
            lcd.printf("Done:%dToDo: %d\n",INTERFACE.Get_Turns_Done(),INTERFACE.Get_Turns_To_Do());
        }
        else if(INTERFACE.Get_Function() == 3)//Twist
        {
            lcd.printf("Mode: Twist\n");      //Top LCD line when the device is Twisting
            lcd.printf("Done:%dToDo: %d\n",INTERFACE.Get_Turns_Done(),INTERFACE.Get_Turns_To_Do());
        }
        Thread::wait(250);//Refresh rate for Lcd
    } 
}
void LED_thread(){//Led thread to toggle the on board led to show the CPU is running
    while (1)
    {
        led2 = !led2;      //Toggle the LED
        Thread::wait(1000);//Wait 1 second
    }
}
//Interrupt functions
void up_thread_function()//Action if the up button is pressed increment
{
    while(1)
    {
        /*
        Thread::signal_wait(1);  //Wait to be signaled by the up button interrupt
        Thread::wait(Debounce_Time); //Button debounce to prevent multiple re-runs
        Thread::signal_wait(2);  //Wait to be signaled by the up button interrupt
        
        */
        Thread::signal_wait(1);  //Wait to be signaled by the up button interrupt
        pc.printf("Up Button Pressed in thread function\n");//Output data to the putty terminal
        Thread::wait(Debounce_Time); //Button debounce to prevent multiple re-runs this debouce time might need to be longer
        up_thread.signal_set(0); //Set the thread signal low to wait for the interrupt before reaccuring
        pc.printf("Up Button Pressed\n");//Output data to the putty terminal
        INTERFACE.Up();     //Run the interface up routine
    }
}
void down_thread_function() //Action if the down button is pressed decrement
{
    while(1)
    {
         /*
        Thread::signal_wait(1);  //Wait to be signaled by the down button interrupt
        Thread::wait(Debounce_Time); //Button debounce to prevent multiple re-runs
        Thread::signal_wait(2);  //Wait to be signaled by the down button interrupt
        
        */
        Thread::signal_wait(1);  //Wait to be signaled by the down button interrupt
        Thread::wait(Debounce_Time); //Button debounce to prevent multiple re-runsn this debounce time might need to be longer
        down_thread.signal_set(0);//Set the thread signal low to wait for the interrupt before reaccuring
        pc.printf("Down Button Pressed\n");//Output data to the putty terminal
        INTERFACE.Down();//Run the interface down routine
    }
}
void start_stop_thread_function() //Action if the Start/Stop button is pressed
{
    while(1)
    {
        Thread::signal_wait(1);  //Wait to be signaled by the start / stop button interrupt
        Thread::wait(Debounce_Time); //Button debounce to prevent multiple re-runsn this debounce time might need to be longer
        start_stop_thread.signal_set(0);//Set the thread signal low to wait for the interrupt before reaccuring
        pc.printf("S/S Button Pressed\n");//Output data to the putty terminal
        INTERFACE.Start_Stop();//Run the interface start / stop routine
        //Thread::wait(1000);//Button debounce to prevent multiple re-runs
    }
}
void Function_Selection_thread_function()//Action if the Function button is pressed
{
    while(1)
    {
        Thread::signal_wait(1);  //Wait to be signaled by the function button interrupt
        Thread::wait(Debounce_Time); //Button debounce to prevent multiple re-runsn this debounce time might need to be longer
        function_thread.signal_set(0);//Set the thread signal low to wait for the interrupt before reaccuring
        pc.printf("Function Button Pressed\n");//Output data to the putty terminal
        INTERFACE.Function();//Run the interface function routine
        //Thread::wait(2000);//Button debounce to prevent multiple re-runs
    }
}
void Selection_thread_function()//Action if the Select button is pressed
{
    while(1)
    {
        Thread::signal_wait(1);  //Wait to be signaled by the select button interrupt
        Thread::wait(Debounce_Time); //Button debounce to prevent multiple re-runsn this debounce time might need to be longer
        select_thread.signal_set(0);//Set the thread signal low to wait for the interrupt before reaccuring
        pc.printf("Select Button Pressed\n");//Output data to the putty terminal
        INTERFACE.Select();//Run the interface selection routine
        //Thread::wait(1000);//Button debounce to prevent multiple re-runs
    }
}
int main() 
{
    //Interrupt setters

    
    lcd.printf("Ready   Player\n");
    lcd.printf("     One      \n");
    Thread::wait(1000);
    pc.printf("Program start\n");//Outputs informtation to the putty terminal
    
    //Thread Initialisation
    polling_thread.start(Polling_thread_function);//Start the button polling
    lcd_thread.start(LCD_thread);//Output data to LCD
    led_thread.start(LED_thread);//Blinking led to show CPU running    
    up_thread.start(up_thread_function);//UP interface thread
    down_thread.start(down_thread_function);//Down interface thread
    start_stop_thread.start(start_stop_thread_function);//Start / stop interface thread
    function_thread.start(Function_Selection_thread_function);//Function interface thread
    select_thread.start(Selection_thread_function);//Start interface thread
    
    osThreadSetPriority(osThreadGetId(), osPriorityHigh);//This is done to make sure the code for the stepper motor is the highest priority to ensure correct rotations of the stepper motor
    INTERFACE.Interface_Init();
    while(1)// Main code in a main thread
    {
        INTERFACE.Interface_main();//Run main thread code
        Thread::wait(10);//Small delay to save CPU time  
    } 
}
