#include "mbed.h"
#include "rtos.h"

InterruptIn inter(p5);      //Se declara la variable de la interrupción
DigitalOut senal(p7);       //Se declara el pin el cual insertará la señal al pin de la interrupción
DigitalIn pulsos(p6);       //Pin en el cual se insertarán los pulsos del encoder.
AnalogIn pot(p19);
//Timer t;                    //Función que medirá el tiempo de operación
Thread thread;              //Función que se ejecutará en paralelo al programa principal 
float velo;                  //Variable flotante en la cual se guardará la velocidad en rpm
int iteraciones=0;          //iteraciones=Variable que contará el número de pulsos

void contador() {              //Función ejecutada por la interrupción inter, la cual es un contador para la variable iteración
    iteraciones=iteraciones+1;
}

void vel() {                                                    //Funcion Se convierte de iteraciones a rpmn vel, ejecutada por el hilo secundario
    while (1) {                                                 //Se ejecuta siempre
        //t.reset();                                              //Se inicializa el timer
        Thread::wait(1000);                                     //Se espera 1 segundo
        //printf("n vale:  %d\n\r", iteraciones);                 //Se imprime el número de iteraciones para monitorear
        velo= iteraciones*30;                             //Se convierte de iteraciones a rpm        
        printf("La velocidad en rpm es:  %f\n\r", velo);           //Se imprimen las rpm
        //printf("El Pot es:  %f\n\r", pot.read());
        //printf("el tiempo es:  %f\n\r", t.read());            //Se imprime el tiempo de ejecución para monitorear
        iteraciones=0;                                          //Se comienza la cuenta de iteraciones de 0, para el siguiente ciclo
        }
    }
    
int main() {                    //Hilo principal
    //t.start();                  //Se inicializa el timer    
    thread.start(vel);          //Se inicializa el hilo secundario
    while(1) {                  
        inter.rise(&contador);     //Se declara la interrupción
        senal=pulsos.read();    //se filtra la señal del encoder, para limpar el ruido.
    }
}
