#include "mbed.h"
#include "rtos.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
InterruptIn inter(p5);          //Se declara la variable de la interrupción
DigitalOut senal(p7);           //Se declara el pin el cual insertará la señal al pin de la interrupción
DigitalIn pulsos(p6);           //Pin en el cual se insertarán los pulsos del encoder.
DigitalOut senal1(p21);
DigitalIn opto(p23);
AnalogIn pot(p19);

Timer t;                        //Función que medirá el tiempo de operación
Thread thread, thread2, thread3, thread4;              //Función que se ejecutará en paralelo al programa principal 
float velo=0, vRef=0, err=0, p=0, control=0, b=0, c=0, Control1=0;                     //Variable flotante en la cual se guardará la velocidad en rpm
int iteraciones=0;              //iteraciones=Variable que contará el número de pulsos

void controlador() {               
    //Thread::wait(3000);
    while(1) {
    senal1=0;
    b = pot.read();
    c = b*0.00833*1000;
    if (opto==1)
    {
        Thread::wait(c); 
        senal1=1;
        Thread::wait(.3);
        senal1=0;
        Thread::wait(9-c);    
    }    
    }
}

void contador() {               //Función ejecutada por la interrupción inter, la cual es un contador para la variable iteración
    iteraciones=iteraciones+1;
}

void filtro() {              
    while(1){
        senal=pulsos.read();    //se filtra la señal del encoder, para limpar el ruido.
        }
}

void interr() {              
    inter.rise(&contador);      //Se declara la interrupción
}

void vel() {                                                    //Funcion Se convierte de iteraciones a rpmn vel, ejecutada por el hilo secundario
    while (1) {                                                 //Se ejecuta siempre
        t.reset();                                              //Se inicializa el timer
        Thread::wait(1000);                                     //Se espera 1 segundo
        printf("n vale:  %d\n\r", iteraciones);                 //Se imprime el número de iteraciones para monitorear
        velo= iteraciones*60*t.read();                          //Se convierte de iteraciones a rpm        
        printf("La velocidad en rpm es:  %f\n\r", velo);        //Se imprimen las rpm
        printf("El Pot es:  %f\n\r", pot.read());
        //printf("el tiempo es:  %f\n\r", t.read());            //Se imprime el tiempo de ejecución para monitorear
        iteraciones=0;                                          //Se comienza la cuenta de iteraciones de 0, para el siguiente ciclo
        }
    }
    
int main() {
    //vRef=600;                    //Hilo principal
    t.start();                  //Se inicializa el timer    
    thread.start(vel);          //Se inicializa el hilo secundario
    thread2.start(filtro);
    thread3.start(interr);
    thread4.start(controlador);
    //p=0.4295;
    /*while(1) {
    err= vRef-velo;
    control= p*err;             // Rango de error es de 0 a 1500; cuando el error es 1500 el angulo debe ser 
    if(err<0){
        led1=!led1;
        }
    if(err>1000){
        led2=!led2;
        }
    if(err>=0 && err<600){
        Control1=control/257.7;
        }
    if(err==600){
        
        }
    if(err>600 && err<1000){
        
        }  */  
    }
