#include "mbed.h"
#include <PwmIn.h>
#include <stdio.h>
 
DigitalIn mybutton(USER_BUTTON);
DigitalOut trig(PA_10);
Serial pc(USBTX,USBRX);
PwmOut servo(PB_5);
PwmIn LidarI(PB_3);


void Mesure(float *pmes){
    wait_ms(40); //Laisser le moteur arriver à sa position
    trig = 1;
    trig=0;        // Déclenchement
    wait_ms(10);  //Attendre que le signal du LIDAR soit clair pour le microcontroleur et pas parasité par le front descendant du déclenchement
    *pmes = LidarI.pulsewidth() / 10;  //Lecture du signal et enregistrement dans la variable "mes"
    trig = 1;  //Stop de la prise de mesure
    pc.printf("Mesure : %f",pmes); //Affichage de la mesure prise 
}

/*Procédure de rotation 
void rotation(float angle){
 
 
 }
*/

int aireSegment (float t[],float angle,int i){
    return (t[i - 1] * t[i] * sin(angle) ) / 2;
}
 
 
int main() {
    // Déclarations des variables
    float mes = 0;          //Variable qui contient les mesures 
    float *pmes = &mes;     //Pointeur qui permettra d'accéder à la variable mesure en dehors du sous programme principale "main"
   // int arret = 0
    float aireTotale = 0, angle=1.0f,A = 1.0f;   // "aireTotale" permet de récupérer la valeur recherchée, on y ajoute l'aire de chaque segments à chaque calcul de ceux-ci
                                                 // "Angle" de chaque rotation du moteur entre chaque prises de mesure (en degrés d'angle !!!)
                                                 // "A" un flottant qui permet de controler le servomoteur (en millisecondes !!!)
    
    int i = 0,nbMes = 180/angle;            // "i" sert d'index dans le tableau dans lequel on stock les mesures 
                                            // "nbMes" correspond au nombre de mesure qui seront effectuées
    
    float tabM[nbMes];              // "tabM" Un tableau dans lequel sera enregistré les mesures effectuées
    
    pc.printf("\nLancement du programme...\n");
 
    trig = 1;                    // "trig" à 1 --> LIDAR attend que "trig" passe à 0 pour prendre des mesures en somme il est en "standby"
    servo.pulsewidth_us(A*1000); // On fixe le servomoteur à son angle minimum       
    Mesure(pmes);                // Lancement de la fonction qui prend une mesure et qui inscrit dans "mes" lavaleur de la mesure effectuée
    tabM[i]=mes;                 // La mesure est enregistrée dans le tableau des mesures
    i++;                         // L'index du tableau augment donc d'un
    wait(1);                     
    while(A<=2.0f){                             // Tant que l'angle envoyé au servomoteur est inférieur ou égal à son angle maximum
        //Fonction rotation moteur    
        servo.pulsewidth_us(A*1000);            // Positionnement du Moteur à sa position minimum
        A += (angle/180.0f); //Vérifier si le moteur tourne bien!!!   // Rotation du moteur d'un angle de la valeur contenu dans la variable angle
        Mesure(pmes);                          // Effectue une mesure et la stocke dans la variable "mes"
        tabM[i]=mes;                            // Stock la valeur contenu dans la varaible "mes" dans le tableau 
        i++;                                    // incrémentation de l'index du tableau des mesures
        
        
        //aireTriangle = (tabM[i - 1] * tabM[i] * sin(angle) ) / 2;
        aireTotale += aireSegment(tabM,angle,i);    //Calcul de l'aire de chaque segment et de l'aire totale
        
        
    }                                           // Fin Tant que
    servo.pulsewidth(0);                        // 
    i=0;                                        // Reinitialisation de i pour pouvoir le reutiliser
    while(i<nbMes){                               // Affichage des mesures
        pc.printf("M(%d):[%f]\n",i ,tabM[i]);      //
        i=i++;                                      //
    }
    
    pc.printf("\n Aire total : %f \n", aireTotale);     
    pc.printf("Arret du programme...");
    sleep();
}
 
 
 
 
 
 
 
 /* DEUXIEME VERSION A METTRE DANS MAIN
    passe dans la tableau et calcule l'aire une fois que les mesures sont prises
    
    
 i = 1;
 while (i < n){
     
     aireTriangle = (tabM[i - 1] * tabM[i] * sin(angle) ) / 2;
     aireTotale += aireTriangle;
     i++;
     }
 
 
 
 */
 
 
 
 
 
 
 
 
 